/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class JobsPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem jobsAll = new PermissionItem("All", "allows to have all actions on jobs", "jobs:*");
    private PermissionItem jobsHold = new PermissionItem("Hold", "allows to have permission to HOLD jobs", "jobs:hold");
    private PermissionItem jobsRelease = new PermissionItem("Release", "allows to have permission to RELEASE jobs, previously changed in HOLD", "jobs:release");
    private PermissionItem jobsPurge = new PermissionItem("Purge", "allows to have permission to PURGE jobs from queues", "jobs:purge");
    private PermissionItem jobsCancel = new PermissionItem("Cancel", "allows to have permission to CANCEL jobs in execution", "jobs:cancel");
    private PermissionItem jobsKill = new PermissionItem("Kill", "allows to have permission to KILL jobs in execution", "jobs:kill");
    private PermissionItem jobsSubmit = new PermissionItem("Submit", "allows to have permission to SUBMIT jobs", "jobs:submit");

    public JobsPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("jobs") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("jobs:*") || permission.startsWith("*")) {
                this.jobsAll.setValue(true);
                for (int i = 0; i < Permissions.JOBS_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.JOBS_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.jobsAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (JobsPermissionsPanel.this.jobsAll.getValue()) {
                    if (!JobsPermissionsPanel.this.getRole().getPermissions().contains("jobs:*")) {
                        Iterator iter = JobsPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("jobs")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.JOBS_ALL.length; ++i) {
                            PermissionItem checkBox = JobsPermissionsPanel.this.getPermissionItemByPermission(Permissions.JOBS_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        JobsPermissionsPanel.this.getRole().getPermissions().add("jobs:*");
                    }
                } else {
                    JobsPermissionsPanel.this.getRole().getPermissions().remove("jobs:*");
                    for (int i = 0; i < Permissions.JOBS_ALL.length; ++i) {
                        PermissionItem checkBox = JobsPermissionsPanel.this.getPermissionItemByPermission(Permissions.JOBS_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.jobsHold);
        this.loadCheckBoxAction(this.jobsRelease);
        this.loadCheckBoxAction(this.jobsPurge);
        this.loadCheckBoxAction(this.jobsCancel);
        this.loadCheckBoxAction(this.jobsKill);
        this.loadCheckBoxAction(this.jobsSubmit);
        this.setItems(this.jobsAll, this.jobsHold, this.jobsRelease, this.jobsPurge, this.jobsCancel, this.jobsKill, this.jobsSubmit);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("jobs:hold")) {
            return this.jobsHold;
        }
        if (permission.equalsIgnoreCase("jobs:release")) {
            return this.jobsRelease;
        }
        if (permission.equalsIgnoreCase("jobs:purge")) {
            return this.jobsPurge;
        }
        if (permission.equalsIgnoreCase("jobs:cancel")) {
            return this.jobsCancel;
        }
        if (permission.equalsIgnoreCase("jobs:kill")) {
            return this.jobsKill;
        }
        if (permission.equalsIgnoreCase("jobs:submit")) {
            return this.jobsSubmit;
        }
        if (permission.equalsIgnoreCase("jobs:*")) {
            return this.jobsAll;
        }
        return null;
    }
}

