/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class GfsPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem gfsAll = new PermissionItem("All", "allows to see all global file system folders", "gfs:*");
    private PermissionItem gfsData = new PermissionItem("Data", "allows to see data folder", "gfs:data");
    private PermissionItem gfsSource = new PermissionItem("Sources", "allows to see sources folder", "gfs:sources");
    private PermissionItem gfsLibrary = new PermissionItem("Library", "allows to see library folder", "gfs:library");
    private PermissionItem gfsClasspath = new PermissionItem("Classpath", "allows to see classpath folder", "gfs:class");
    private PermissionItem gfsBinary = new PermissionItem("Binary", "allows to see binary folder", "gfs:binary");

    public GfsPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("gfs") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("gfs:*") || permission.startsWith("*")) {
                this.gfsAll.setValue(true);
                for (int i = 0; i < Permissions.GFS_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.GFS_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.gfsAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (GfsPermissionsPanel.this.gfsAll.getValue()) {
                    if (!GfsPermissionsPanel.this.getRole().getPermissions().contains("gfs:*")) {
                        Iterator iter = GfsPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("gfs")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.GFS_ALL.length; ++i) {
                            PermissionItem checkBox = GfsPermissionsPanel.this.getPermissionItemByPermission(Permissions.GFS_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        GfsPermissionsPanel.this.getRole().getPermissions().add("gfs:*");
                    }
                } else {
                    GfsPermissionsPanel.this.getRole().getPermissions().remove("gfs:*");
                    for (int i = 0; i < Permissions.GFS_ALL.length; ++i) {
                        PermissionItem checkBox = GfsPermissionsPanel.this.getPermissionItemByPermission(Permissions.GFS_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.gfsData);
        this.loadCheckBoxAction(this.gfsSource);
        this.loadCheckBoxAction(this.gfsLibrary);
        this.loadCheckBoxAction(this.gfsClasspath);
        this.loadCheckBoxAction(this.gfsBinary);
        this.setItems(this.gfsAll, this.gfsData, this.gfsSource, this.gfsLibrary, this.gfsClasspath, this.gfsBinary);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("gfs:data")) {
            return this.gfsData;
        }
        if (permission.equalsIgnoreCase("gfs:sources")) {
            return this.gfsSource;
        }
        if (permission.equalsIgnoreCase("gfs:library")) {
            return this.gfsLibrary;
        }
        if (permission.equalsIgnoreCase("gfs:class")) {
            return this.gfsClasspath;
        }
        if (permission.equalsIgnoreCase("gfs:binary")) {
            return this.gfsBinary;
        }
        if (permission.equalsIgnoreCase("gfs:*")) {
            return this.gfsAll;
        }
        return null;
    }
}

