/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class CertificatesPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem certificatesAll = new PermissionItem("All", "allows to have all actions on certificates management", "certificates:*");
    private PermissionItem certificatesCreate = new PermissionItem("Read", "allows to have READ permission, to see certificates attributes", "certificates:read");
    private PermissionItem certificatesDelete = new PermissionItem("Delete", "allows to have DELETE permission, to remove certificates", "certificates:delete");
    private PermissionItem certificatesRead = new PermissionItem("Create", "allows to have CREATE permission, to create new certificates", "certificates:create");

    public CertificatesPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("certificates") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("certificates:*") || permission.startsWith("*")) {
                this.certificatesAll.setValue(true);
                for (int i = 0; i < Permissions.CERTIFICATES_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.CERTIFICATES_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.certificatesAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (CertificatesPermissionsPanel.this.certificatesAll.getValue()) {
                    if (!CertificatesPermissionsPanel.this.getRole().getPermissions().contains("certificates:*")) {
                        Iterator iter = CertificatesPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("certificates")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.CERTIFICATES_ALL.length; ++i) {
                            PermissionItem checkBox = CertificatesPermissionsPanel.this.getPermissionItemByPermission(Permissions.CERTIFICATES_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        CertificatesPermissionsPanel.this.getRole().getPermissions().add("certificates:*");
                    }
                } else {
                    CertificatesPermissionsPanel.this.getRole().getPermissions().remove("certificates:*");
                    for (int i = 0; i < Permissions.CERTIFICATES_ALL.length; ++i) {
                        PermissionItem checkBox = CertificatesPermissionsPanel.this.getPermissionItemByPermission(Permissions.CERTIFICATES_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.certificatesRead);
        this.loadCheckBoxAction(this.certificatesDelete);
        this.loadCheckBoxAction(this.certificatesCreate);
        this.setItems(this.certificatesAll, this.certificatesRead, this.certificatesDelete, this.certificatesCreate);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("certificates:create")) {
            return this.certificatesCreate;
        }
        if (permission.equalsIgnoreCase("certificates:delete")) {
            return this.certificatesDelete;
        }
        if (permission.equalsIgnoreCase("certificates:read")) {
            return this.certificatesRead;
        }
        if (permission.equalsIgnoreCase("certificates:*")) {
            return this.certificatesAll;
        }
        return null;
    }
}

