/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.commons;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.CellTableStyle;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.components.RemovePanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.InputPanel;
import org.pepstock.jem.node.security.Role;

public abstract class ListPermissionsPanel
extends HorizontalPanel
implements InspectListener<String>,
ClickHandler,
ResizeCapable {
    private Role role = null;
    private RemovePanel remove = new RemovePanel();
    private InputPanel inputPanel = null;
    private CellList<String> cellList = null;
    private ScrollPanel scroller = new ScrollPanel();
    private final SingleSelectionModel<String> selectionModel = new SingleSelectionModel();
    private final ArrayList<String> permissionSubList = new ArrayList();
    private String mainPermission = null;

    public ListPermissionsPanel(Role role, String mainPermission, String inputLabel, AbstractCell<String> cell) {
        this.setRole(role);
        this.setMainPermission(mainPermission);
        this.cellList = new CellList(cell, (CellList.Resources)GWT.create(CellTableStyle.class));
        this.loadSubList();
        this.inputPanel = new InputPanel(inputLabel);
        this.inputPanel.setListener(this);
        this.add((Widget)this.inputPanel);
        this.cellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.cellList.setSelectionModel(this.selectionModel);
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                String selected = (String)ListPermissionsPanel.this.selectionModel.getSelectedObject();
                if (selected != null) {
                    ListPermissionsPanel.this.remove.setEnabled(true);
                }
            }
        });
        this.cellList.setRowCount(this.permissionSubList.size(), true);
        this.cellList.setRowData(0, this.permissionSubList);
        this.scroller.setWidget(this.cellList);
        VerticalPanel scrollHolder = new VerticalPanel();
        scrollHolder.setSize("100%", "100%");
        scrollHolder.addStyleName(Styles.INSTANCE.administration().nodeList());
        scrollHolder.add((Widget)this.scroller);
        VerticalPanel listContainer = new VerticalPanel();
        listContainer.setSpacing(5);
        Label label = new Label("Permissions");
        label.addStyleName(Styles.INSTANCE.common().bold());
        label.setHeight(Sizes.toString(24));
        listContainer.add((Widget)label);
        listContainer.add((Widget)scrollHolder);
        this.add((Widget)listContainer);
        this.remove.setClickHandler(this);
        this.add((Widget)this.remove);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public InputPanel getInputPanel() {
        return this.inputPanel;
    }

    public void setInputPanel(InputPanel inputPanel) {
        this.inputPanel = inputPanel;
    }

    public String getMainPermission() {
        return this.mainPermission;
    }

    public void setMainPermission(String mainPermission) {
        this.mainPermission = mainPermission;
    }

    public void remove(String selectedPermission) {
        this.role.getPermissions().remove(selectedPermission);
        this.permissionSubList.remove(selectedPermission);
        this.cellList.setRowCount(this.permissionSubList.size());
        this.cellList.setRowData(0, this.permissionSubList);
        this.remove.setEnabled(false);
    }

    public void add(String selectedPermission) {
        String permission;
        String string = permission = selectedPermission.startsWith(this.getMainPermission()) ? selectedPermission : this.getMainPermission() + ":" + selectedPermission;
        if (!this.role.getPermissions().contains(permission)) {
            this.role.getPermissions().add(permission);
            this.permissionSubList.add(permission);
            this.cellList.setRowCount(this.permissionSubList.size());
            this.cellList.setRowData(0, this.permissionSubList);
            this.inputPanel.clear();
            if (this.selectionModel.isSelected((Object)permission)) {
                this.remove.setEnabled(true);
            }
        }
    }

    private void loadSubList() {
        for (String permission : this.role.getPermissions()) {
            if (!permission.startsWith(this.getMainPermission())) continue;
            this.permissionSubList.add(permission);
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        int widthInputPanel = 310;
        int widthRemovePanel = 110;
        int width = availableWidth - widthInputPanel - widthRemovePanel - 5 - 5 - 1 - 1;
        int height = availableHeight - 5 - 5 - 5 - 24 - 1 - 1;
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(width));
    }

    public void onClick(ClickEvent event) {
        String selected = (String)this.selectionModel.getSelectedObject();
        this.remove(selected);
    }

    @Override
    public void inspect(String object) {
        this.add(object);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.administration().ensureInjected();
    }
}

