/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.commons;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;

public class InputPanel
extends VerticalPanel {
    public static final int SPACING = 5;
    public static final int LABEL_HEIGHT = 24;
    public static final int WIDTH = 300;
    private final Button add = new Button("Add");
    private final TextBox permissionBox = new TextBox();
    private InspectListener<String> listener = null;

    public InputPanel(String header) {
        this.setWidth(Sizes.toString(300));
        this.setSpacing(5);
        this.add.setEnabled(false);
        Label label = new Label(header);
        label.addStyleName(Styles.INSTANCE.common().bold());
        label.setHeight(Sizes.toString(24));
        this.add((Widget)label);
        this.permissionBox.setVisibleLength(40);
        this.permissionBox.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (InputPanel.this.permissionBox.getText().length() > 0) {
                    InputPanel.this.add.setEnabled(true);
                } else {
                    InputPanel.this.add.setEnabled(false);
                }
            }
        });
        this.permissionBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13 && InputPanel.this.add.isEnabled()) {
                    InputPanel.this.add.click();
                }
            }
        });
        this.add.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InputPanel.this.listener != null) {
                    InputPanel.this.listener.inspect(InputPanel.this.permissionBox.getText());
                }
            }
        });
        this.add((Widget)this.permissionBox);
        this.add((Widget)this.add);
    }

    public InspectListener<String> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<String> listener) {
        this.listener = listener;
    }

    public void clear() {
        this.permissionBox.setText("");
    }

    public void setEnabled(boolean enabled) {
        this.add.setEnabled(enabled);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

