/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;

public class TreeOptions
extends ScrollPanel {
    public static final String VIEWS = "views";
    public static final String JOBS = "jobs";
    public static final String NODES = "nodes";
    public static final String SWARM = "swarm";
    public static final String ROLES = "roles";
    public static final String RESOURCES = "resources";
    public static final String GFS = "gfs";
    public static final String CERTIFICATES = "certificates";
    public static final String ADMINISTRATION = "admin";
    private InspectListener<String> listener = null;
    private VerticalPanel selected = null;

    public TreeOptions() {
        this.setWidth("100%");
        this.setHeight("100%");
        VerticalPanel views = this.createItem("Views", VIEWS);
        VerticalPanel jobs = this.createItem("Jobs", JOBS);
        VerticalPanel nodes = this.createItem("Nodes", NODES);
        VerticalPanel roles = this.createItem("Roles", ROLES);
        VerticalPanel swarm = this.createItem("Swarm", SWARM);
        VerticalPanel resources = this.createItem("Resources", RESOURCES);
        VerticalPanel gfs = this.createItem("Global file system", GFS);
        VerticalPanel certificates = this.createItem("Certificates", CERTIFICATES);
        VerticalPanel admin = this.createItem("Administration", ADMINISTRATION);
        Grid grid = new Grid(9, 1);
        grid.setWidget(0, 0, (Widget)views);
        grid.setWidget(1, 0, (Widget)jobs);
        grid.setWidget(2, 0, (Widget)nodes);
        grid.setWidget(3, 0, (Widget)roles);
        grid.setWidget(4, 0, (Widget)certificates);
        grid.setWidget(5, 0, (Widget)swarm);
        grid.setWidget(6, 0, (Widget)resources);
        grid.setWidget(7, 0, (Widget)gfs);
        grid.setWidget(8, 0, (Widget)admin);
        this.add((Widget)grid);
        this.selectPanel(views);
    }

    public void setListener(InspectListener<String> listener) {
        this.listener = listener;
    }

    private void selectPanel(VerticalPanel select) {
        if (select.equals(this.selected)) {
            return;
        }
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.common().adminUnselectedTreeItem());
        }
        select.setStyleName(Styles.INSTANCE.common().adminSelectedTreeItem());
        this.selected = select;
    }

    private final VerticalPanel createItem(String description, final String option) {
        final VerticalPanel options = new VerticalPanel();
        options.setSpacing(8);
        options.setWidth("100%");
        Anchor anchor = new Anchor(description);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TreeOptions.this.listener != null) {
                    TreeOptions.this.listener.inspect(option);
                    TreeOptions.this.selectPanel(options);
                }
            }
        });
        options.add((Widget)anchor);
        return options;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

