/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AbstractInspector;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.ViewStackPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.Actions;
import org.pepstock.jem.gwt.client.panels.resources.inspector.FTPAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.HTTPAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JDBCAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JMSAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.JPPFAttributesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.NewResourceHeader;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourceHeader;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.Resource;

public class ResourceInspector
extends AbstractInspector {
    public static final int NEW = 0;
    public static final int UPDATE = 1;
    public static final int CLONE = 2;
    private Resource resource = null;
    private int action = 0;
    private ListBox typeSelection = new ListBox();
    private String selectItem = "Select a Resource Type";
    private String jdbcItem = "JDBC";
    private String ftpItem = "FTP";
    private String jmsItem = "JMS";
    private String httpItem = "HTTP";
    private String jppfItem = "JPPF";
    private Actions actions = null;
    private VerticalPanel mainContainer = new VerticalPanel();
    private ViewStackPanel stack = new ViewStackPanel();
    private JDBCAttributesPanel jdbcPanel = null;
    private FTPAttributesPanel ftpPanel = null;
    private JMSAttributesPanel jmsPanel = null;
    private HTTPAttributesPanel httpPanel = null;
    private JPPFAttributesPanel jppfPanel = null;
    private static final int LIST_HEIGHT = 40;

    public ResourceInspector() {
        this(new Resource(), 0);
    }

    public ResourceInspector(Resource resource) {
        this(resource, 1);
    }

    public ResourceInspector(Resource resource, int action) {
        super(true);
        this.setResource(resource);
        this.setAction(action);
        this.jdbcPanel = new JDBCAttributesPanel(resource);
        this.ftpPanel = new FTPAttributesPanel(resource);
        this.jmsPanel = new JMSAttributesPanel(resource);
        this.httpPanel = new HTTPAttributesPanel(resource);
        this.jppfPanel = new JPPFAttributesPanel(resource);
        if (this.getAction() == 0) {
            HorizontalPanel type = new HorizontalPanel();
            type.setHeight(Sizes.toString(40));
            this.typeSelection.addStyleName(Styles.INSTANCE.common().bold());
            this.typeSelection.addItem(this.selectItem);
            this.typeSelection.addItem(this.jdbcItem);
            this.typeSelection.addItem(this.ftpItem);
            this.typeSelection.addItem(this.jmsItem);
            this.typeSelection.addItem(this.httpItem);
            this.typeSelection.addItem(this.jppfItem);
            this.typeSelection.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    int selectedIndex = ResourceInspector.this.typeSelection.getSelectedIndex();
                    if (selectedIndex > 0) {
                        ResourceInspector.this.typeSelection.setEnabled(false);
                        ResourceInspector.this.stack.showStack(selectedIndex);
                        ((ResourcesPropertiesPanel)ResourceInspector.this.stack.getSelectedWidget()).initializeResource();
                    }
                }
            });
            type.add((Widget)this.typeSelection);
            type.setCellVerticalAlignment((Widget)this.typeSelection, HasVerticalAlignment.ALIGN_MIDDLE);
            type.setSpacing(6);
            int newAvailableHeight = this.getAvailableHeight() - 40;
            this.stack.setHeight(Sizes.toString(newAvailableHeight));
            SimplePanel empty = new SimplePanel();
            this.stack.add((Widget)empty);
            this.stack.add((Widget)this.jdbcPanel);
            this.stack.add((Widget)this.ftpPanel);
            this.stack.add((Widget)this.jmsPanel);
            this.stack.add((Widget)this.httpPanel);
            this.stack.add((Widget)this.jppfPanel);
            this.jdbcPanel.onResize(this.getAvailableWidth(), newAvailableHeight);
            this.ftpPanel.onResize(this.getAvailableWidth(), newAvailableHeight);
            this.jmsPanel.onResize(this.getAvailableWidth(), newAvailableHeight);
            this.httpPanel.onResize(this.getAvailableWidth(), newAvailableHeight);
            this.jppfPanel.onResize(this.getAvailableWidth(), newAvailableHeight);
            this.stack.showStack(0);
            this.mainContainer.add((Widget)type);
            this.mainContainer.add((Widget)this.stack);
        } else if (resource.getType().equalsIgnoreCase("ftp")) {
            this.mainContainer.add((Widget)this.ftpPanel);
            this.ftpPanel.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        } else if (resource.getType().equalsIgnoreCase("jdbc")) {
            this.mainContainer.add((Widget)this.jdbcPanel);
            this.jdbcPanel.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        } else if (resource.getType().equalsIgnoreCase("jms")) {
            this.mainContainer.add((Widget)this.jmsPanel);
            this.jmsPanel.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        } else if (resource.getType().equalsIgnoreCase("http")) {
            this.mainContainer.add((Widget)this.httpPanel);
            this.httpPanel.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        } else if (resource.getType().equalsIgnoreCase("jppf")) {
            this.mainContainer.add((Widget)this.jppfPanel);
            this.jppfPanel.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        }
        this.actions = new Actions(resource);
        this.actions.setInspector(this);
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void cancel() {
        this.hide();
    }

    private boolean checkMandatoryAttributes() {
        if (this.resource.getType().equalsIgnoreCase("jms")) {
            return this.jmsPanel.checkMandatoryAttributes();
        }
        if (this.resource.getType().equalsIgnoreCase("http")) {
            return this.httpPanel.checkMandatoryAttributes();
        }
        if (this.resource.getType().equalsIgnoreCase("jdbc")) {
            return this.jdbcPanel.checkMandatoryAttributes();
        }
        if (this.resource.getType().equalsIgnoreCase("ftp")) {
            return this.ftpPanel.checkMandatoryAttributes();
        }
        if (this.resource.getType().equalsIgnoreCase("jppf")) {
            return this.jppfPanel.checkMandatoryAttributes();
        }
        return true;
    }

    public void save() {
        if (this.checkMandatoryAttributes()) {
            if (this.resource.getName() != null) {
                if (!this.resource.getName().trim().isEmpty()) {
                    if (this.getAction() != 1) {
                        Services.COMMON_RESOURCES_MANAGER.addCommonResource(this.resource, new AsyncCallback<Boolean>(){

                            public void onSuccess(Boolean result) {
                                ResourceInspector.this.hide();
                            }

                            public void onFailure(Throwable caught) {
                                ResourceInspector.this.hide();
                                AlertMessageBox alert = new AlertMessageBox(2, "Add resource command error!", caught.getMessage());
                                alert.open();
                            }
                        });
                    } else {
                        Services.COMMON_RESOURCES_MANAGER.updateCommonResource(this.resource, new AsyncCallback<Boolean>(){

                            public void onSuccess(Boolean result) {
                                ResourceInspector.this.hide();
                            }

                            public void onFailure(Throwable caught) {
                                ResourceInspector.this.hide();
                                AlertMessageBox alert = new AlertMessageBox(2, "Update resource command error!", caught.getMessage());
                                alert.open();
                            }
                        });
                    }
                } else {
                    AlertMessageBox alert = new AlertMessageBox(2, "Resource name empty!", "Resource name is empty. Please type a resource name");
                    alert.open();
                }
            } else {
                AlertMessageBox alert = new AlertMessageBox(2, "Invalid resource name!", "Please type a valid resource name");
                alert.open();
            }
        }
    }

    @Override
    public FlexTable getHeader() {
        if (this.getAction() == 1) {
            return new ResourceHeader("[" + this.getResource().getType() + "] " + this.getResource().getName(), this);
        }
        return new NewResourceHeader(this.getResource(), this);
    }

    @Override
    public Panel getContent() {
        return this.mainContainer;
    }

    @Override
    public Panel getActions() {
        return this.actions;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

