/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.nodes.commons.inspector;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.TimeDisplayUtils;
import org.pepstock.jem.gwt.client.commons.UITools;
import org.pepstock.jem.node.ExecutionEnvironment;

public class General
extends DefaultInspectorItem {
    private static final int RUNNING_TIME_REFRESH_INTERVAL = 20000;
    private NodeInfoBean node = null;
    private Timer elapsedTimer = null;

    public General(final NodeInfoBean node) {
        this.setNodeInfoBean(node);
        HorizontalPanel hp = new HorizontalPanel();
        hp.setWidth("100%");
        hp.setHeight("100%");
        hp.setSpacing(10);
        VerticalPanel nodeVp = new VerticalPanel();
        nodeVp.setWidth("100%");
        hp.add((Widget)nodeVp);
        hp.setCellWidth((Widget)nodeVp, "50%");
        Label nodeLabel = new Label("Node information");
        nodeLabel.setWidth("100%");
        nodeLabel.setStyleName(Styles.INSTANCE.inspector().title());
        nodeLabel.addStyleName(Styles.INSTANCE.common().bold());
        nodeVp.add((Widget)nodeLabel);
        final FlexTable layoutNode = new FlexTable();
        layoutNode.setCellPadding(10);
        layoutNode.setWidth("100%");
        layoutNode.setHTML(0, 0, "Label");
        layoutNode.setWidget(0, 1, (Widget)new HTML(node.getLabel()));
        layoutNode.setHTML(1, 0, "Status");
        layoutNode.setWidget(1, 1, (Widget)new HTML(node.getStatus()));
        layoutNode.setHTML(2, 0, "Host");
        layoutNode.setWidget(2, 1, (Widget)new HTML(node.getHostname()));
        layoutNode.setHTML(3, 0, "IP:Port");
        layoutNode.setWidget(3, 1, (Widget)new HTML(node.getIpaddress() + ":" + node.getPort()));
        layoutNode.setHTML(4, 0, "Running time");
        layoutNode.setWidget(4, 1, (Widget)new HTML("(updating)"));
        this.elapsedTimer = new Timer(){

            public void run() {
                String displayed;
                layoutNode.setWidget(4, 1, (Widget)new HTML("(updating)"));
                try {
                    displayed = TimeDisplayUtils.getReadableTimeDiff(node.getStartedTime());
                }
                catch (Exception e) {
                    displayed = "(unavailable)";
                }
                layoutNode.setWidget(4, 1, (Widget)new HTML(displayed));
            }
        };
        this.elapsedTimer.run();
        this.elapsedTimer.scheduleRepeating(20000);
        layoutNode.setHTML(5, 0, "Key");
        layoutNode.setWidget(5, 1, (Widget)new HTML(node.getKey()));
        layoutNode.setHTML(6, 0, "RMI Port");
        layoutNode.setWidget(6, 1, (Widget)new HTML(String.valueOf(node.getRmiPort())));
        layoutNode.setHTML(7, 0, "Jem Version");
        layoutNode.setWidget(7, 1, (Widget)new HTML(node.getJemVersion()));
        UITools.setFlexTableStyles(layoutNode, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        nodeVp.add((Widget)layoutNode);
        VerticalPanel envVp = new VerticalPanel();
        envVp.setWidth("100%");
        hp.add((Widget)envVp);
        hp.setCellWidth((Widget)envVp, "50%");
        Label envLabel = new Label("Execution environment");
        envLabel.setWidth("100%");
        envLabel.setStyleName(Styles.INSTANCE.inspector().title());
        envLabel.addStyleName(Styles.INSTANCE.common().bold());
        envVp.add((Widget)envLabel);
        FlexTable layoutEnvironment = new FlexTable();
        layoutEnvironment.setCellPadding(10);
        layoutEnvironment.setWidth("100%");
        ExecutionEnvironment env = node.getExecutionEnvironment();
        layoutEnvironment.setHTML(0, 0, "Name");
        layoutEnvironment.setWidget(0, 1, (Widget)new HTML(env.getEnvironment()));
        layoutEnvironment.setHTML(1, 0, "Domain");
        layoutEnvironment.setWidget(1, 1, (Widget)new HTML(env.getDomain()));
        layoutEnvironment.setHTML(2, 0, "Affinities");
        layoutEnvironment.setWidget(2, 1, (Widget)new HTML(env.getAffinities().toString()));
        UITools.setFlexTableStyles(layoutEnvironment, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        envVp.add((Widget)layoutEnvironment);
        this.add((Widget)hp);
    }

    public NodeInfoBean getNodeInfoBean() {
        return this.node;
    }

    public void setNodeInfoBean(NodeInfoBean node) {
        this.node = node;
    }

    protected void onDetach() {
        try {
            this.elapsedTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onDetach();
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.inspector().ensureInjected();
    }
}

