/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.nodes;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.NodeStatusImages;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.panels.nodes.NodesComparator;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;

public class NodesTable
extends AbstractTable<NodeInfoBean> {
    @Override
    public IndexedColumnComparator<NodeInfoBean> initCellTable(CellTable<NodeInfoBean> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<NodeInfoBean, Boolean> checkColumn = new Column<NodeInfoBean, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(NodeInfoBean nodeInfoBean) {
                return selectionModel.isSelected((Object)nodeInfoBean);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (NodesTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (NodeInfoBean n : NodesTable.this.getTable().getVisibleItems()) {
                    if (NodesTable.this.getTable().getSelectionModel().isSelected((Object)n)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (NodeInfoBean n : NodesTable.this.getTable().getVisibleItems()) {
                    NodesTable.this.getTable().getSelectionModel().setSelected((Object)n, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        AnchorTextColumn<NodeInfoBean> name = new AnchorTextColumn<NodeInfoBean>(){

            @Override
            public String getValue(NodeInfoBean object) {
                return object.getLabel();
            }

            @Override
            public void onClick(int index, NodeInfoBean object, String value) {
                NodesTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", NodeFilterFields.NAME.getName()));
        TextColumn<NodeInfoBean> hostname = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getHostname();
            }
        };
        hostname.setSortable(true);
        table.addColumn((Column)hostname, (Header)new TextFilterableHeader("Hostname", NodeFilterFields.HOSTNAME.getName()));
        TextColumn<NodeInfoBean> domain = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.isSuperNode() ? "" : nodeInfoBean.getExecutionEnvironment().getDomain();
            }
        };
        domain.setSortable(true);
        table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", NodeFilterFields.DOMAIN.getName()));
        TextColumn<NodeInfoBean> affinity = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.isSuperNode() ? "" : nodeInfoBean.getExecutionEnvironment().getAffinities().toString();
            }
        };
        affinity.setSortable(true);
        table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Affinities", NodeFilterFields.AFFINITIES.getName()));
        TextColumn<NodeInfoBean> status = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean object) {
                if (object == null || object.getStatus() == null) {
                    return "";
                }
                return object.getStatus();
            }

            public void render(Cell.Context context, NodeInfoBean object, SafeHtmlBuilder sb) {
                if (object == null || object.getStatus() == null || object.getStatus().trim().isEmpty()) {
                    return;
                }
                String statusString = object.getStatus();
                NodeStatusImages statusObject = statusString.equals(NodeStatusImages.UNKNOWN.toString()) ? NodeStatusImages.UNKNOWN : (statusString.equals(NodeStatusImages.STARTING.toString()) ? NodeStatusImages.STARTING : (statusString.equals(NodeStatusImages.INACTIVE.toString()) ? NodeStatusImages.INACTIVE : (statusString.equals(NodeStatusImages.ACTIVE.toString()) ? NodeStatusImages.ACTIVE : (statusString.equals(NodeStatusImages.DRAINED.toString()) ? NodeStatusImages.DRAINED : (statusString.equals(NodeStatusImages.DRAINING.toString()) ? NodeStatusImages.DRAINING : (statusString.equals(NodeStatusImages.SHUTTING_DOWN.toString()) ? NodeStatusImages.SHUTTING_DOWN : NodeStatusImages.INACTIVE))))));
                sb.appendHtmlConstant("<table>");
                sb.appendHtmlConstant("<tr><td>");
                String imageHtml = AbstractImagePrototype.create((ImageResource)statusObject.getImage()).getHTML();
                sb.appendHtmlConstant(imageHtml);
                sb.appendHtmlConstant("</td>");
                sb.appendHtmlConstant("<td align='left' valign='middle'>");
                sb.appendEscaped(statusString);
                if (!object.isOperational()) {
                    sb.appendEscaped(" (not operational)");
                }
                sb.appendHtmlConstant("</td></tr></table>");
            }
        };
        status.setSortable(true);
        table.addColumn((Column)status, (Header)new TextFilterableHeader("Status", NodeFilterFields.STATUS.getName()));
        TextColumn<NodeInfoBean> systemName = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getSystemName();
            }
        };
        systemName.setSortable(true);
        table.addColumn((Column)systemName, (Header)new TextFilterableHeader("OS", NodeFilterFields.OS.getName()));
        TextColumn<NodeInfoBean> currentJob = new TextColumn<NodeInfoBean>(){

            public String getValue(NodeInfoBean nodeInfoBean) {
                return nodeInfoBean.getJobName() == null ? "" : nodeInfoBean.getJobName();
            }
        };
        currentJob.setSortable(true);
        table.addColumn((Column)currentJob, (Header)new TextFilterableHeader("Current Job", NodeFilterFields.CURRENT_JOB.getName()));
        return new NodesComparator(1);
    }
}

