/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.running;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.view.client.SelectionModel;
import java.util.Date;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.commons.TimeDisplayUtils;
import org.pepstock.jem.gwt.client.panels.jobs.running.RunningJobComparator;
import org.pepstock.jem.gwt.client.panels.jobs.running.RunningTextColumn;
import org.pepstock.jem.util.filters.fields.JobFilterFields;

public class RunningTable
extends AbstractTable<Job> {
    public RunningTable(boolean filterableHeaders) {
        super(filterableHeaders);
    }

    @Override
    public IndexedColumnComparator<Job> initCellTable(CellTable<Job> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<Job, Boolean> checkColumn = new Column<Job, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Job job) {
                return selectionModel.isSelected((Object)job);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (RunningTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (Job j : RunningTable.this.getTable().getVisibleItems()) {
                    if (RunningTable.this.getTable().getSelectionModel().isSelected((Object)j)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (Job j : RunningTable.this.getTable().getVisibleItems()) {
                    RunningTable.this.getTable().getSelectionModel().setSelected((Object)j, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        AnchorTextColumn<Job> name = new AnchorTextColumn<Job>(){

            @Override
            public String getValue(Job object) {
                return object.getName();
            }

            @Override
            public void onClick(int index, Job object, String value) {
                RunningTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        RunningTextColumn type = new RunningTextColumn(){

            public String getValue(Job job) {
                return job.getJcl().getType();
            }
        };
        type.setSortable(true);
        RunningTextColumn userid = new RunningTextColumn(){

            public String getValue(Job job) {
                return job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser();
            }
        };
        userid.setSortable(true);
        RunningTextColumn step = new RunningTextColumn(){

            public String getValue(Job job) {
                if (job.getCurrentStep() != null) {
                    return job.getCurrentStep().getName();
                }
                return "";
            }
        };
        RunningTextColumn domain = new RunningTextColumn(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.getDomain();
            }
        };
        domain.setSortable(true);
        RunningTextColumn affinity = new RunningTextColumn(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.getAffinity();
            }
        };
        affinity.setSortable(true);
        RunningTextColumn runningTime = new RunningTextColumn(){

            public String getValue(Job job) {
                Date startedTime = job.getStartedTime();
                return TimeDisplayUtils.getReadableTimeDiff(startedTime);
            }
        };
        runningTime.setSortable(true);
        RunningTextColumn memory = new RunningTextColumn(){

            public String getValue(Job job) {
                return String.valueOf(job.getJcl().getMemory());
            }
        };
        memory.setSortable(true);
        RunningTextColumn member = new RunningTextColumn(){

            public String getValue(Job job) {
                return job.getMemberLabel();
            }
        };
        member.setSortable(true);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        if (this.hasFilterableHeaders()) {
            table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", JobFilterFields.NAME.getName()));
            table.addColumn((Column)type, (Header)new TextFilterableHeader("Type", JobFilterFields.TYPE.getName()));
            table.addColumn((Column)userid, (Header)new TextFilterableHeader("User", JobFilterFields.USER.getName()));
            table.addColumn((Column)step, (Header)new TextFilterableHeader("Step", JobFilterFields.STEP.getName()));
            table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", JobFilterFields.DOMAIN.getName()));
            table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Affinity", JobFilterFields.AFFINITY.getName()));
            table.addColumn((Column)runningTime, (Header)new TextFilterableHeader("Running time", JobFilterFields.RUNNING_TIME.getName(), JobFilterFields.RUNNING_TIME.getPattern()));
            table.addColumn((Column)memory, (Header)new TextFilterableHeader("Memory (MB)", JobFilterFields.MEMORY.getName()));
            table.addColumn((Column)member, (Header)new TextFilterableHeader("Member", JobFilterFields.MEMBER.getName()));
        } else {
            table.addColumn((Column)name, "Name");
            table.addColumn((Column)type, "Type");
            table.addColumn((Column)userid, "User");
            table.addColumn((Column)step, "Step");
            table.addColumn((Column)domain, "Domain");
            table.addColumn((Column)affinity, "Affinity");
            table.addColumn((Column)runningTime, "Running time");
            table.addColumn((Column)memory, "Memory (MB)");
            table.addColumn((Column)member, "Member");
        }
        return new RunningJobComparator(1);
    }
}

