/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.running;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.panels.jobs.commons.AbstractJobsActions;
import org.pepstock.jem.gwt.client.security.ClientPermissions;

public class RunningActions
extends AbstractJobsActions {
    public RunningActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addCancelButton();
        this.addForceButton();
    }

    private void addCancelButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:cancel")) {
            Button cancelButton = new Button("Cancel", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)RunningActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No job selected!", "No job is selected and it's not possible to perform CANCEL command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm CANCEL", "Are you sure you want to cancel the selected jobs?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                RunningActions.this.cancel(selectionModel.getSelectedSet(), false);
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)cancelButton);
        }
    }

    private void addForceButton() {
        if (ClientPermissions.isAuthorized("jobs", "jobs:kill")) {
            Button forceButton = new Button("Kill", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)RunningActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No job selected!", "No job is selected and it's not possible to perform FORCE command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm FORCE", "Are you sure you want to cancel with FORCE the selected jobs?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                RunningActions.this.cancel(selectionModel.getSelectedSet(), true);
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)forceButton);
        }
    }
}

