/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.routing;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.panels.jobs.routing.RoutingJobComparator;
import org.pepstock.jem.util.filters.fields.JobFilterFields;

public class RoutingTable
extends AbstractTable<Job> {
    public RoutingTable(boolean filterableHeaders) {
        super(filterableHeaders);
    }

    @Override
    public IndexedColumnComparator<Job> initCellTable(CellTable<Job> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<Job, Boolean> checkColumn = new Column<Job, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Job job) {
                return selectionModel.isSelected((Object)job);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (RoutingTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (Job j : RoutingTable.this.getTable().getVisibleItems()) {
                    if (RoutingTable.this.getTable().getSelectionModel().isSelected((Object)j)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (Job j : RoutingTable.this.getTable().getVisibleItems()) {
                    RoutingTable.this.getTable().getSelectionModel().setSelected((Object)j, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        AnchorTextColumn<Job> name = new AnchorTextColumn<Job>(){

            @Override
            public String getValue(Job object) {
                return object.getName();
            }

            @Override
            public void onClick(int index, Job object, String value) {
                RoutingTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        TextColumn<Job> type = new TextColumn<Job>(){

            public String getValue(Job job) {
                return job.getJcl().getType();
            }
        };
        type.setSortable(true);
        TextColumn<Job> userid = new TextColumn<Job>(){

            public String getValue(Job job) {
                return job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser();
            }
        };
        userid.setSortable(true);
        TextColumn<Job> environment = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.getEnvironment();
            }
        };
        environment.setSortable(true);
        TextColumn<Job> domain = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.getDomain();
            }
        };
        domain.setSortable(true);
        TextColumn<Job> affinity = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.getAffinity();
            }
        };
        affinity.setSortable(true);
        TextColumn<Job> submittedDate = new TextColumn<Job>(){

            public String getValue(Job job) {
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(job.getSubmittedTime());
            }
        };
        submittedDate.setSortable(true);
        TextColumn<Job> priority = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return String.valueOf(jcl.getPriority());
            }
        };
        TextColumn<Job> hold = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.isHold() ? "hold" : "";
            }
        };
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        if (this.hasFilterableHeaders()) {
            table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", JobFilterFields.NAME.getName()));
            table.addColumn((Column)type, (Header)new TextFilterableHeader("Type", JobFilterFields.TYPE.getName()));
            table.addColumn((Column)userid, (Header)new TextFilterableHeader("User", JobFilterFields.USER.getName()));
            table.addColumn((Column)environment, (Header)new TextFilterableHeader("Environment", JobFilterFields.ENVIRONMENT.getName()));
            table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", JobFilterFields.DOMAIN.getName()));
            table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Affinity", JobFilterFields.AFFINITY.getName()));
            table.addColumn((Column)submittedDate, (Header)new TextFilterableHeader("Submitted time", JobFilterFields.SUBMITTED_TIME.getName(), JobFilterFields.SUBMITTED_TIME.getPattern()));
            table.addColumn((Column)priority, (Header)new TextFilterableHeader("Priority", JobFilterFields.PRIORITY.getName()));
        } else {
            table.addColumn((Column)name, "Name");
            table.addColumn((Column)type, "Type");
            table.addColumn((Column)userid, "User");
            table.addColumn((Column)environment, "Environment");
            table.addColumn((Column)domain, "Domain");
            table.addColumn((Column)affinity, "Affinity");
            table.addColumn((Column)submittedDate, "Submitted time");
            table.addColumn((Column)priority, "Priority");
        }
        table.addColumn((Column)hold, "Hold");
        return new RoutingJobComparator(1);
    }
}

