/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.input;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.commons.UpdateListener;
import org.pepstock.jem.gwt.client.panels.jobs.input.InputJobComparator;
import org.pepstock.jem.util.filters.fields.JobFilterFields;

public class InputTable
extends AbstractTable<Job> {
    public InputTable(boolean filterableHeaders) {
        super(filterableHeaders);
    }

    @Override
    public IndexedColumnComparator<Job> initCellTable(CellTable<Job> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<Job, Boolean> checkColumn = new Column<Job, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Job job) {
                return selectionModel.isSelected((Object)job);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (InputTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (Job j : InputTable.this.getTable().getVisibleItems()) {
                    if (InputTable.this.getTable().getSelectionModel().isSelected((Object)j)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (Job j : InputTable.this.getTable().getVisibleItems()) {
                    InputTable.this.getTable().getSelectionModel().setSelected((Object)j, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        AnchorTextColumn<Job> name = new AnchorTextColumn<Job>(){

            @Override
            public String getValue(Job object) {
                return object.getName();
            }

            @Override
            public void onClick(int index, Job object, String value) {
                InputTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        TextColumn<Job> type = new TextColumn<Job>(){

            public String getValue(Job job) {
                return job.getJcl().getType();
            }
        };
        type.setSortable(true);
        TextColumn<Job> userid = new TextColumn<Job>(){

            public String getValue(Job job) {
                return job.isUserSurrogated() ? job.getJcl().getUser() : job.getUser();
            }
        };
        userid.setSortable(true);
        Column<Job, String> environment = new Column<Job, String>((Cell)new EditTextCell()){

            public String getValue(Job object) {
                return object.getJcl().getEnvironment();
            }
        };
        environment.setFieldUpdater((FieldUpdater)new FieldUpdater<Job, String>(){

            public void update(int index, Job job, String value) {
                if (value != null && value.trim().length() > 0) {
                    if (!value.equalsIgnoreCase(job.getJcl().getEnvironment())) {
                        job.getJcl().setEnvironment(value);
                        InputTable.this.updateJob(job);
                    }
                    return;
                }
                InputTable.this.refresh();
            }
        });
        Column<Job, String> domain = new Column<Job, String>((Cell)new EditTextCell()){

            public String getValue(Job object) {
                return object.getJcl().getDomain();
            }
        };
        domain.setSortable(true);
        domain.setFieldUpdater((FieldUpdater)new FieldUpdater<Job, String>(){

            public void update(int index, Job job, String value) {
                if (value != null) {
                    if (value.trim().length() == 0) {
                        value = "***";
                    }
                    if (!value.equalsIgnoreCase(job.getJcl().getDomain())) {
                        job.getJcl().setDomain(value);
                        InputTable.this.updateJob(job);
                    }
                    return;
                }
                InputTable.this.refresh();
            }
        });
        Column<Job, String> affinity = new Column<Job, String>((Cell)new EditTextCell()){

            public String getValue(Job object) {
                return object.getJcl().getAffinity();
            }
        };
        affinity.setSortable(true);
        affinity.setFieldUpdater((FieldUpdater)new FieldUpdater<Job, String>(){

            public void update(int index, Job job, String value) {
                if (value != null) {
                    if (value.trim().length() == 0) {
                        value = "***";
                    }
                    if (!value.equalsIgnoreCase(job.getJcl().getAffinity())) {
                        job.getJcl().setAffinity(value);
                        InputTable.this.updateJob(job);
                    }
                    return;
                }
                InputTable.this.refresh();
            }
        });
        TextColumn<Job> submittedDate = new TextColumn<Job>(){

            public String getValue(Job job) {
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(job.getSubmittedTime());
            }
        };
        submittedDate.setSortable(true);
        Column<Job, String> priority = new Column<Job, String>((Cell)new EditTextCell()){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return String.valueOf(jcl.getPriority());
            }
        };
        priority.setSortable(true);
        priority.setFieldUpdater((FieldUpdater)new FieldUpdater<Job, String>(){

            public void update(int index, Job job, String value) {
                if (value != null) {
                    int prio = job.getJcl().getPriority();
                    try {
                        prio = Integer.parseInt(value);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (prio != job.getJcl().getPriority()) {
                        job.getJcl().setPriority(prio);
                        InputTable.this.updateJob(job);
                    }
                    return;
                }
                InputTable.this.refresh();
            }
        });
        Column<Job, String> memory = new Column<Job, String>((Cell)new EditTextCell()){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return String.valueOf(jcl.getMemory());
            }
        };
        memory.setSortable(true);
        memory.setFieldUpdater((FieldUpdater)new FieldUpdater<Job, String>(){

            public void update(int index, Job job, String value) {
                if (value != null) {
                    int mem = job.getJcl().getMemory();
                    try {
                        mem = Integer.parseInt(value);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (mem != job.getJcl().getMemory()) {
                        job.getJcl().setMemory(mem);
                        InputTable.this.updateJob(job);
                    }
                    return;
                }
                InputTable.this.refresh();
            }
        });
        TextColumn<Job> hold = new TextColumn<Job>(){

            public String getValue(Job job) {
                Jcl jcl = job.getJcl();
                return jcl.isHold() ? "hold" : "";
            }
        };
        hold.setSortable(true);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        if (this.hasFilterableHeaders()) {
            table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", JobFilterFields.NAME.getName()));
            table.addColumn((Column)type, (Header)new TextFilterableHeader("Type", JobFilterFields.TYPE.getName()));
            table.addColumn((Column)userid, (Header)new TextFilterableHeader("User", JobFilterFields.USER.getName()));
            table.addColumn((Column)environment, (Header)new TextFilterableHeader("Environment", JobFilterFields.ENVIRONMENT.getName()));
            table.addColumn((Column)domain, (Header)new TextFilterableHeader("Domain", JobFilterFields.DOMAIN.getName()));
            table.addColumn((Column)affinity, (Header)new TextFilterableHeader("Affinity", JobFilterFields.AFFINITY.getName()));
            table.addColumn((Column)submittedDate, (Header)new TextFilterableHeader("Submitted time", JobFilterFields.SUBMITTED_TIME.getName(), JobFilterFields.SUBMITTED_TIME.getPattern()));
            table.addColumn((Column)priority, (Header)new TextFilterableHeader("Priority", JobFilterFields.PRIORITY.getName()));
            table.addColumn((Column)memory, (Header)new TextFilterableHeader("Memory (MB)", JobFilterFields.MEMORY.getName()));
        } else {
            table.addColumn((Column)name, "Name");
            table.addColumn((Column)type, "Type");
            table.addColumn((Column)userid, "User");
            table.addColumn((Column)environment, "Environment");
            table.addColumn((Column)domain, "Domain");
            table.addColumn((Column)affinity, "Affinity");
            table.addColumn((Column)submittedDate, "Submitted time");
            table.addColumn((Column)priority, "Priority");
            table.addColumn((Column)memory, "Memory (MB)");
        }
        table.addColumn((Column)hold, "Hold");
        return new InputJobComparator(1);
    }

    private void refresh() {
        this.updateJob(null);
    }

    private void updateJob(Job job) {
        InspectListener listener = this.getInspectListener();
        if (listener instanceof UpdateListener) {
            UpdateListener ulistener = (UpdateListener)listener;
            ulistener.update(job);
        }
    }
}

