/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pepstock.jem.Job;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.ViewText;
import org.pepstock.jem.gwt.client.editor.SyntaxHighlighter;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.ItemAnchor;
import org.pepstock.jem.gwt.client.services.Services;

public class Output
extends DefaultInspectorItem
implements SyntaxHighlighter {
    private final Loading loading = new Loading();
    private final VerticalPanel log = new VerticalPanel();
    private final ScrollPanel scrollerFiles = new ScrollPanel();
    private ViewText viewOutput = new ViewText();
    private SplitLayoutPanel splitPanel = new SplitLayoutPanel();
    private HorizontalPanel selected = null;

    public Output(Job job, OutputTree outputTree) {
        final Job thisJob = job;
        DisclosurePanel root = new DisclosurePanel(job.getName());
        root.setAnimationEnabled(true);
        VerticalPanel firstLevelPanel = new VerticalPanel();
        firstLevelPanel.setSpacing(1);
        for (OutputListItem item : outputTree.getFirstLevelItems()) {
            final HorizontalPanel options = new HorizontalPanel();
            options.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
            options.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            options.setSpacing(8);
            options.setWidth("100%");
            final ItemAnchor anchor = new ItemAnchor(item);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Output.this.output(thisJob, anchor.getItem());
                    Output.this.selectPanel(options);
                }
            });
            options.add((Widget)anchor);
            options.setCellWidth((Widget)anchor, "100%");
            firstLevelPanel.add((Widget)options);
        }
        root.setOpen(true);
        VerticalPanel secondAndFirstLevelPanel = new VerticalPanel();
        secondAndFirstLevelPanel.add((Widget)firstLevelPanel);
        for (String key : outputTree.getSecondLevelItems().keySet()) {
            DisclosurePanel secondPanel = new DisclosurePanel(key);
            secondPanel.setAnimationEnabled(true);
            VerticalPanel secondLevelPanel = new VerticalPanel();
            secondLevelPanel.setSpacing(1);
            for (OutputListItem item : (ArrayList)outputTree.getSecondLevelItems().get(key)) {
                final HorizontalPanel options = new HorizontalPanel();
                options.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
                options.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                options.setSpacing(8);
                options.setWidth("100%");
                final ItemAnchor anchor = new ItemAnchor(item);
                anchor.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Output.this.output(thisJob, anchor.getItem());
                        Output.this.selectPanel(options);
                    }
                });
                options.add((Widget)anchor);
                options.setCellWidth((Widget)anchor, "100%");
                secondLevelPanel.add((Widget)options);
            }
            secondPanel.setContent((Widget)secondLevelPanel);
            secondAndFirstLevelPanel.add((Widget)secondPanel);
        }
        root.setContent((Widget)secondAndFirstLevelPanel);
        this.scrollerFiles.add((Widget)root);
        this.scrollerFiles.setWidth(Sizes.toString(200));
        this.log.add((Widget)this.viewOutput);
        this.log.setVisible(false);
        this.splitPanel.setWidth("100%");
        this.splitPanel.addWest((Widget)this.scrollerFiles, 200.0);
        this.splitPanel.add((Widget)this.log);
        this.add((Widget)this.splitPanel);
    }

    private void selectPanel(HorizontalPanel select) {
        if (select.equals(this.selected)) {
            return;
        }
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.common().adminUnselectedTreeItem());
        }
        select.setStyleName(Styles.INSTANCE.common().adminSelectedTreeItem());
        this.selected = select;
    }

    public void output(final Job job, final OutputListItem item) {
        this.loading.startProcessing();
        this.log.setVisible(true);
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getOutputFileContent(job, item, new AsyncCallback<OutputFileContent>(){

                    public void onFailure(Throwable caught) {
                        Output.this.loading.stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Get OUTPUT error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(OutputFileContent result) {
                        Output.this.loading.stopProcessing();
                        String label = item.getParent() != null ? "[" + item.getParent() + "] - " + item.getLabel() : item.getLabel();
                        String content = null;
                        content = result.getContent() == null ? "(none)" : (result.getContent().trim().length() == 0 ? "(none)" : result.getContent());
                        Output.this.viewOutput.setContent(content);
                        Output.this.viewOutput.startEditor();
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        this.splitPanel.setHeight(Sizes.toString(availableHeight));
        this.scrollerFiles.setHeight(Sizes.toString(availableHeight));
        int syntaxHighlighterWidth = availableWidth - 200 - 8;
        int syntaxHighlighterHeight = availableHeight - 2;
        this.viewOutput.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
    }

    @Override
    public void startEditor() {
    }

    @Override
    public void destroyEditor() {
        this.viewOutput.destroyEditor();
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.administration().ensureInjected();
    }
}

