/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.UITools;

public class General
extends DefaultInspectorItem {
    private Job job = null;
    private DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");

    public General(final Job job) {
        this.setJob(job);
        HorizontalPanel hp = new HorizontalPanel();
        hp.setWidth("100%");
        hp.setHeight("100%");
        hp.setSpacing(10);
        VerticalPanel jobVp = new VerticalPanel();
        jobVp.setWidth("100%");
        hp.add((Widget)jobVp);
        hp.setCellWidth((Widget)jobVp, "50%");
        Label jobLabel = new Label("Job information");
        jobLabel.setWidth("100%");
        jobLabel.setStyleName(Styles.INSTANCE.inspector().title());
        jobLabel.addStyleName(Styles.INSTANCE.common().bold());
        jobVp.add((Widget)jobLabel);
        FlexTable layoutJob = new FlexTable();
        layoutJob.setCellPadding(10);
        layoutJob.setWidth("100%");
        layoutJob.setHTML(0, 0, "Name");
        layoutJob.setWidget(0, 1, (Widget)new HTML(job.getName()));
        layoutJob.setHTML(1, 0, "ID");
        layoutJob.setWidget(1, 1, (Widget)new HTML(job.getId()));
        layoutJob.setHTML(2, 0, "User");
        layoutJob.setWidget(2, 1, (Widget)new HTML(job.getUser()));
        layoutJob.setHTML(3, 0, "Process ID");
        if (job.getProcessId() == null) {
            layoutJob.setHTML(3, 1, "");
        } else {
            layoutJob.setWidget(3, 1, (Widget)new HTML(job.getProcessId()));
        }
        layoutJob.setHTML(4, 0, "Submitted");
        layoutJob.setWidget(4, 1, (Widget)new HTML(this.dtf.format(job.getSubmittedTime())));
        layoutJob.setHTML(5, 0, "Started");
        if (job.getStartedTime() == null) {
            layoutJob.setHTML(5, 0, "");
        } else {
            layoutJob.setWidget(5, 1, (Widget)new HTML(this.dtf.format(job.getStartedTime())));
        }
        layoutJob.setHTML(6, 0, "Ended");
        if (job.getEndedTime() == null) {
            layoutJob.setHTML(6, 1, "");
        } else {
            layoutJob.setWidget(6, 1, (Widget)new HTML(this.dtf.format(job.getEndedTime())));
        }
        layoutJob.setHTML(7, 0, "Current Step");
        if (job.getCurrentStep() == null || job.getEndedTime() != null) {
            layoutJob.setHTML(7, 1, "");
        } else {
            layoutJob.setWidget(7, 1, (Widget)new HTML(job.getCurrentStep().getName()));
        }
        layoutJob.setHTML(8, 0, "Result");
        if (job.getResult() == null) {
            layoutJob.setHTML(8, 1, "");
        } else {
            layoutJob.setWidget(8, 1, (Widget)new HTML(String.valueOf(job.getResult().getReturnCode())));
            if (job.getResult().getExceptionMessage() != null) {
                layoutJob.setHTML(9, 0, "Exception");
                String fullMessage = job.getResult().getExceptionMessage();
                int indexFirstRow = fullMessage.indexOf(10);
                String message = null;
                message = indexFirstRow == -1 ? fullMessage : fullMessage.substring(0, indexFirstRow);
                layoutJob.setHTML(9, 1, message);
            }
        }
        UITools.setFlexTableStyles(layoutJob, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        jobVp.add((Widget)layoutJob);
        VerticalPanel jclVp = new VerticalPanel();
        jclVp.setWidth("100%");
        hp.add((Widget)jclVp);
        hp.setCellWidth((Widget)jclVp, "50%");
        Label jclLabel = new Label("Jcl information");
        jclLabel.setWidth("100%");
        jclLabel.setStyleName(Styles.INSTANCE.inspector().title());
        jclLabel.addStyleName(Styles.INSTANCE.common().bold());
        jclVp.add((Widget)jclLabel);
        FlexTable layoutJcl = new FlexTable();
        layoutJcl.setCellPadding(10);
        layoutJcl.setWidth("100%");
        layoutJcl.setHTML(0, 0, "Environment");
        layoutJcl.setWidget(0, 1, (Widget)new HTML(job.getJcl().getEnvironment()));
        layoutJcl.setHTML(1, 0, "Domain");
        layoutJcl.setWidget(1, 1, (Widget)new HTML(job.getJcl().getDomain()));
        layoutJcl.setHTML(2, 0, "Affinities");
        layoutJcl.setWidget(2, 1, (Widget)new HTML(job.getJcl().getAffinity()));
        layoutJcl.setHTML(3, 0, "Memory");
        layoutJcl.setWidget(3, 1, (Widget)new HTML(String.valueOf(job.getJcl().getMemory())));
        layoutJcl.setHTML(4, 0, "Priority");
        layoutJcl.setWidget(4, 1, (Widget)new HTML(String.valueOf(job.getJcl().getPriority())));
        final CheckBox hold = new CheckBox();
        hold.setValue(Boolean.valueOf(job.getJcl().isHold()));
        hold.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                hold.setValue(Boolean.valueOf(job.getJcl().isHold()));
            }
        });
        layoutJcl.setHTML(5, 0, "Hold");
        layoutJcl.setWidget(5, 1, (Widget)hold);
        layoutJcl.setHTML(6, 0, "Node");
        if (job.getMemberLabel() == null) {
            layoutJcl.setHTML(6, 1, "");
        } else {
            layoutJcl.setWidget(6, 1, (Widget)new HTML(job.getMemberLabel()));
        }
        UITools.setFlexTableStyles(layoutJcl, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight(), Styles.INSTANCE.common().bold());
        jclVp.add((Widget)layoutJcl);
        this.add((Widget)hp);
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.inspector().ensureInjected();
    }
}

