/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobInspector;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.BrowseJcl;
import org.pepstock.jem.gwt.client.services.Services;

public class EditJcl
extends BrowseJcl {
    private final Loading loading = new Loading();
    private String type = null;
    private JobInspector inspector = null;

    public EditJcl(JobInspector inspector, String content, String type) {
        super(content);
        this.type = type;
        this.inspector = inspector;
    }

    @Override
    public void setEditorAttributes(Editor editor) {
        super.setEditorAttributes(editor);
        editor.setReadOnly(false);
        editor.setHighlightActiveLine(true);
    }

    @Override
    public void setMenuItems(MenuBar menu, boolean jclNotAvailable) {
        Image imgUndo = new Image(Images.INSTANCE.edit_undo());
        imgUndo.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem undo = new MenuItem(imgUndo + "  Undo", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                EditJcl.this.getEditor().setText(EditJcl.this.getContent());
            }
        });
        Image imgIndent = new Image(Images.INSTANCE.edit_indent());
        imgIndent.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem indent = new MenuItem(imgIndent + "  Indent", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (EditJcl.this.getEditor().getText().trim().length() > 0) {
                    Services.QUEUES_MANAGER.indent(EditJcl.this.getEditor().getText(), new AsyncCallback<String>(){

                        public void onSuccess(String result) {
                            EditJcl.this.getEditor().setText(result);
                        }

                        public void onFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, "Indent JCL error!", caught.getMessage());
                            alert.open();
                        }
                    });
                }
            }
        });
        MenuBar editMenu = new MenuBar(true);
        Image imgSelectAll = new Image(Images.INSTANCE.edit_select_all());
        imgSelectAll.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem selectAll = new MenuItem(imgSelectAll + " Select All", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                EditJcl.this.getEditor().selectAll();
            }
        });
        editMenu.addItem(undo);
        editMenu.addItem(selectAll);
        editMenu.addSeparator();
        editMenu.addItem(indent);
        MenuItem submitMenuItem = new MenuItem("Submit", (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (EditJcl.this.getEditor().getText().trim().length() > 0) {
                    EditJcl.this.submit();
                } else {
                    AlertMessageBox alert = new AlertMessageBox(1, "Submit JCL warning!", "JCL content is empty. Submit is not allowed!");
                    alert.open();
                }
            }
        });
        if (jclNotAvailable) {
            indent.setEnabled(false);
            selectAll.setEnabled(false);
        }
        menu.addItem("Actions", editMenu);
        menu.addSeparator();
        menu.addItem(submitMenuItem);
    }

    private void submit() {
        this.inspector.hide();
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.submit(EditJcl.this.getEditor().getText(), EditJcl.this.type, new AsyncCallback<String>(){

                    public void onSuccess(String result) {
                        EditJcl.this.loading.stopProcessing();
                        Toast t = new Toast(0, result, "Job submitted!");
                        t.show();
                    }

                    public void onFailure(Throwable caught) {
                        EditJcl.this.loading.stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Submit job error!", caught.getMessage());
                        alert.open();
                    }
                });
            }
        });
    }
}

