/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons.inspector;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.editor.AbstractSyntaxHighlighter;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.editor.Mode;
import org.pepstock.jem.gwt.client.editor.Theme;
import org.pepstock.jem.gwt.client.services.Services;

public class BrowseJcl
extends AbstractSyntaxHighlighter {
    public BrowseJcl(String id, String content) {
        super(id);
        this.setContent(content);
    }

    public BrowseJcl(String content) {
        this(null, content);
    }

    @Override
    public void setEditorAttributes(Editor editor) {
        editor.setTheme(Theme.ECLIPSE);
        editor.setMode(Mode.XML);
        editor.setReadOnly(true);
        editor.setHighlightActiveLine(false);
    }

    @Override
    public void setMenuItems(MenuBar menu, boolean jclNotAvailable) {
        Image imgIndent = new Image(Images.INSTANCE.edit_indent());
        imgIndent.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem indent = new MenuItem(imgIndent + "  Indent", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                if (BrowseJcl.this.getEditor().getText().trim().length() > 0) {
                    Services.QUEUES_MANAGER.indent(BrowseJcl.this.getEditor().getText(), new AsyncCallback<String>(){

                        public void onSuccess(String result) {
                            BrowseJcl.this.getEditor().setText(result);
                        }

                        public void onFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, "Indent JCL error!", caught.getMessage());
                            alert.open();
                        }
                    });
                }
            }
        });
        MenuBar editMenu = new MenuBar(true);
        Image imgSelectAll = new Image(Images.INSTANCE.edit_select_all());
        imgSelectAll.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        MenuItem selectAll = new MenuItem(imgSelectAll + " Select All", true, (Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                BrowseJcl.this.getEditor().selectAll();
            }
        });
        editMenu.addItem(selectAll);
        editMenu.addSeparator();
        editMenu.addItem(indent);
        if (jclNotAvailable) {
            indent.setEnabled(false);
            selectAll.setEnabled(false);
        }
        menu.addItem("Actions", editMenu);
    }
}

