/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.jobs.commons;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.XmlResultViewer;
import org.pepstock.jem.gwt.client.panels.jobs.commons.inspector.JobHeader;
import org.pepstock.jem.gwt.client.panels.jobs.commons.submitter.Actions;
import org.pepstock.jem.gwt.client.security.CurrentUser;
import org.pepstock.jem.gwt.client.services.Services;

public class Submitter
extends PopupPanel {
    final FormPanel form = new FormPanel();
    final FileUpload fileUpload = new FileUpload();
    private boolean errorRetrievingJCLType = false;
    final ListBox list = new ListBox();
    public static final String SERVICE_NAME = "submitter";
    public static final String FILE_UPLOAD_FIELD = "jcl";
    public static final String TYPE_FIELD = "type";

    public Submitter() {
        super(true, true);
        this.setGlassEnabled(true);
        DockLayoutPanel mainContainer = new DockLayoutPanel(Style.Unit.PX);
        mainContainer.addNorth((Widget)new JobHeader("Submit a job!", this), 75.0);
        VerticalPanel panel = new VerticalPanel();
        this.form.setAction(GWT.getModuleBaseURL() + SERVICE_NAME);
        this.form.setEncoding("multipart/form-data");
        this.form.setMethod("post");
        this.fileUpload.setName(FILE_UPLOAD_FIELD);
        Services.QUEUES_MANAGER.getJclTypes(new AsyncCallback<Map<String, String>>(){

            public void onSuccess(Map<String, String> result) {
                int count = 0;
                Submitter.this.list.setSelectedIndex(0);
                String pref = CurrentUser.getInstance().getStringPreference("job.submit.type");
                for (Map.Entry<String, String> entry : result.entrySet()) {
                    Submitter.this.list.addItem(entry.getValue(), entry.getKey());
                    if (pref != null && pref.equalsIgnoreCase(entry.getKey())) {
                        Submitter.this.list.setSelectedIndex(count);
                        continue;
                    }
                    ++count;
                }
            }

            public void onFailure(Throwable caught) {
                Submitter.this.close();
                Submitter.this.errorRetrievingJCLType = true;
                AlertMessageBox alert = new AlertMessageBox(2, "JCl types Error!", caught.getMessage());
                alert.open();
            }
        });
        this.list.setName(TYPE_FIELD);
        FlexTable layout = new FlexTable();
        layout.setCellPadding(10);
        layout.setWidth("100%");
        layout.setHTML(0, 0, "Select JCL file for job:");
        layout.setWidget(0, 1, (Widget)this.fileUpload);
        layout.setHTML(1, 0, "Select JCL type for job:");
        layout.setWidget(1, 1, (Widget)this.list);
        panel.add((Widget)layout);
        this.form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                String value = Submitter.this.list.getValue(Submitter.this.list.getSelectedIndex());
                CurrentUser.getInstance().setStringPreference("job.submit.type", value);
                XmlResultViewer.showResult("JOB submitted", event.getResults());
                Submitter.this.close();
            }
        });
        panel.setSpacing(10);
        Actions actions = new Actions(this);
        panel.add((Widget)actions);
        this.form.add((Widget)panel);
        mainContainer.add((Widget)this.form);
        this.setWidget((Widget)mainContainer);
    }

    public void submit() {
        String filename = this.fileUpload.getFilename();
        if (filename.length() == 0) {
            AlertMessageBox alert = new AlertMessageBox(2, "File error!", "No file has been specified! Please select a file which represents a job!");
            alert.open();
        } else {
            this.form.submit();
        }
    }

    public void center() {
        if (this.errorRetrievingJCLType) {
            return;
        }
        super.center();
    }

    public void cancel() {
        this.close();
    }

    public void close() {
        this.hide();
    }
}

