/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.gfs.commons;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;

public class PathPanel
extends FlexTable {
    private static final String PATH_SEPARATOR = "/";
    private String[] pathTokens = null;
    private InspectListener<GfsFile> listener = null;

    public PathPanel() {
        this.addStyleName(Styles.INSTANCE.fileSystemBrowser().pathToken());
        this.setHeight(Sizes.toString(44));
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        rf.setVerticalAlign(0, HasVerticalAlignment.ALIGN_MIDDLE);
        FlexTable.FlexCellFormatter cf = this.getFlexCellFormatter();
        cf.setWordWrap(0, 0, false);
        cf.setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT);
        this.setHTML(0, 0, "Path: ");
        final Image homeImage = new Image(Images.INSTANCE.home1_24());
        homeImage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (PathPanel.this.listener != null) {
                    GfsFile file = new GfsFile();
                    file.setName(".");
                    file.setLongName(".");
                    file.setDirectory(true);
                    PathPanel.this.listener.inspect(file);
                }
            }
        });
        homeImage.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                homeImage.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            }
        });
        this.setWidget(0, 1, (Widget)homeImage);
        cf.addStyleName(0, 1, Styles.INSTANCE.common().widthFull());
        cf.setWordWrap(0, 1, false);
    }

    public InspectListener<GfsFile> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<GfsFile> listener) {
        this.listener = listener;
    }

    public void set(GfsFile file, int count) {
        if (file.getLongName().equalsIgnoreCase("*") || file.getLongName().equalsIgnoreCase("/*") || file.getLongName().equalsIgnoreCase(".") || file.getLongName().equalsIgnoreCase("/.")) {
            this.removeColumns();
            this.setCount(count);
            return;
        }
        this.pathTokens = file.getLongName().split(PATH_SEPARATOR);
        this.createPath();
        this.setCount(count);
    }

    private void setCount(int count) {
        int col = this.getCellCount(0) + 1;
        FlexTable.FlexCellFormatter cf = this.getFlexCellFormatter();
        cf.setWidth(0, col, "100%");
        cf.setHorizontalAlignment(0, col, HasHorizontalAlignment.ALIGN_RIGHT);
        this.setHTML(0, col, count > 1 ? count + " files" : count + " file");
        cf.setWordWrap(0, col, false);
    }

    private void removeColumns() {
        int cols = this.getCellCount(0);
        if (cols > 2) {
            this.removeCells(0, 2, cols - 2);
        }
        this.adjustSizes();
    }

    private void createPath() {
        this.removeColumns();
        FlexTable.FlexCellFormatter cf = this.getFlexCellFormatter();
        for (int i = 0; i < this.pathTokens.length; ++i) {
            int index0 = i * 2 + 2;
            cf.setWordWrap(0, index0, false);
            cf.setHorizontalAlignment(0, index0, HasHorizontalAlignment.ALIGN_LEFT);
            this.setHTML(0, index0, PATH_SEPARATOR);
            int index1 = i * 2 + 3;
            cf.setWordWrap(0, index1, false);
            cf.setHorizontalAlignment(0, index1, HasHorizontalAlignment.ALIGN_LEFT);
            this.setWidget(0, index1, (Widget)this.createAnchor(i));
        }
        this.adjustSizes();
    }

    private void adjustSizes() {
        int i;
        FlexTable.FlexCellFormatter cf = this.getFlexCellFormatter();
        for (i = 0; i < this.getCellCount(0); ++i) {
            cf.removeStyleName(0, i, Styles.INSTANCE.common().widthFull());
        }
        cf.addStyleName(0, i - 1, Styles.INSTANCE.common().widthFull());
    }

    private Anchor createAnchor(int index) {
        Anchor anchor = new Anchor(this.pathTokens[index]);
        anchor.addClickHandler((ClickHandler)new MyClickHandler(index));
        return anchor;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.fileSystemBrowser().ensureInjected();
    }

    class MyClickHandler
    implements ClickHandler {
        private int index = 0;

        public MyClickHandler(int index) {
            this.index = index;
        }

        public void onClick(ClickEvent event) {
            if (PathPanel.this.listener != null) {
                String path = "";
                for (int i = 0; i <= this.index; ++i) {
                    path = i == 0 ? PathPanel.this.pathTokens[i] : path + PathPanel.PATH_SEPARATOR + PathPanel.this.pathTokens[i];
                }
                GfsFile file = new GfsFile();
                file.setName(PathPanel.this.pathTokens[this.index]);
                file.setLongName(path);
                file.setDirectory(true);
                PathPanel.this.listener.inspect(file);
            }
        }
    }
}

