/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.gfs.commons;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import java.util.Date;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.FileSystemTableStyle;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.panels.gfs.commons.FolderLinkTextColumn;
import org.pepstock.jem.gwt.client.panels.gfs.commons.FullLinkTextColumn;

public abstract class FilesTable
extends AbstractTable<GfsFile> {
    public FilesTable() {
        super((CellTable.Resources)GWT.create(FileSystemTableStyle.class), Integer.MAX_VALUE);
    }

    @Override
    public final IndexedColumnComparator<GfsFile> initCellTable(CellTable<GfsFile> table) {
        this.loadCellTable(table);
        return this.getIndexedColumnComparator();
    }

    public abstract IndexedColumnComparator<GfsFile> getIndexedColumnComparator();

    private void loadCellTable(CellTable<GfsFile> table) {
        Column name = null;
        if (this.isOverviewOnly()) {
            name = new FolderLinkTextColumn(){

                @Override
                public void onClick(int index, GfsFile object) {
                    FilesTable.this.getInspectListener().inspect(object);
                }
            };
            name.setSortable(true);
            table.addColumn(name, "Name");
        } else {
            name = new FullLinkTextColumn(){

                @Override
                public void onClick(int index, GfsFile object) {
                    FilesTable.this.getInspectListener().inspect(object);
                }
            };
            name.setSortable(true);
            table.addColumn(name, "Name");
        }
        TextColumn<GfsFile> size = new TextColumn<GfsFile>(){

            public String getValue(GfsFile memberSample) {
                long size = memberSample.getLength();
                if (size >= 0L) {
                    return NumberFormat.getFormat((String)"###,###,###,###,###,##0").format((double)size);
                }
                return "";
            }
        };
        size.setSortable(true);
        table.addColumn((Column)size, "Size (bytes)");
        TextColumn<GfsFile> lastMod = new TextColumn<GfsFile>(){

            public String getValue(GfsFile file) {
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(new Date(file.getLastModified()));
            }
        };
        lastMod.setSortable(true);
        table.addColumn((Column)lastMod, "Last modified");
    }

    public abstract boolean isOverviewOnly();
}

