/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.queues.inspector;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.BackListener;
import org.pepstock.jem.gwt.client.panels.administration.commons.InspectorHeader;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.queues.inspector.Data;
import org.pepstock.jem.gwt.client.panels.administration.queues.inspector.QueuesTable;
import org.pepstock.jem.gwt.client.panels.administration.queues.inspector.TimeSeriesChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightSample;

public class InspectorPanel
extends AdminPanel
implements ResizeCapable {
    final TabPanel mainTabPanel = new TabPanel();
    private TimeSeriesChart chartEntries = new TimeSeriesChart(0);
    private TimeSeriesChart chartHits = new TimeSeriesChart(1);
    private TimeSeriesChart chartLocked = new TimeSeriesChart(2);
    private TimeSeriesChart chartWaits = new TimeSeriesChart(3);
    private TimeSeriesChart chartGets = new TimeSeriesChart(4);
    private TimeSeriesChart chartPuts = new TimeSeriesChart(5);
    private TimeSeriesChart chartRemoves = new TimeSeriesChart(6);
    private TableContainer<Data> queues = new TableContainer<Data>(new QueuesTable());
    private ScrollPanel scroller = new ScrollPanel(this.queues);
    private InspectorHeader header = new InspectorHeader("Queue:");
    private ArrayList<Data> listData = new ArrayList();
    private VerticalPanel entPanel = new VerticalPanel();
    private VerticalPanel hitPanel = new VerticalPanel();
    private VerticalPanel lokPanel = new VerticalPanel();
    private VerticalPanel waitPanel = new VerticalPanel();
    private VerticalPanel getPanel = new VerticalPanel();
    private VerticalPanel putPanel = new VerticalPanel();
    private VerticalPanel remPanel = new VerticalPanel();

    public InspectorPanel() {
        this.mainTabPanel.add((Widget)this.entPanel, "Entries", false);
        this.mainTabPanel.add((Widget)this.hitPanel, "Hits", false);
        this.mainTabPanel.add((Widget)this.lokPanel, "Locked", false);
        this.mainTabPanel.add((Widget)this.waitPanel, "LockWaits", false);
        this.mainTabPanel.add((Widget)this.getPanel, "Gets", false);
        this.mainTabPanel.add((Widget)this.putPanel, "Puts", false);
        this.mainTabPanel.add((Widget)this.remPanel, "Removes", false);
        this.mainTabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                InspectorPanel.this.loadChart((Integer)event.getSelectedItem());
            }
        });
        this.add((Widget)this.header);
        this.add((Widget)this.mainTabPanel);
        this.add((Widget)this.scroller);
    }

    public BackListener getListener() {
        return this.header.getListener();
    }

    public void setListener(BackListener listener) {
        this.header.setListener(listener);
    }

    public void load(String queueName) {
        this.listData.clear();
        for (LightSample sample : Instances.getSamples()) {
            Data data = new Data();
            data.setKey(sample.getTime());
            data.setTime(sample.getKey());
            for (LightMemberSample msample : sample.getMembers()) {
                LightMapStats map = (LightMapStats)msample.getMapsStats().get(queueName);
                data.setEntries(map.getOwnedEntryCount() + data.getEntries());
                data.setGets(map.getHits() + data.getHits());
                data.setGets(map.getLockedEntryCount() + data.getLocked());
                data.setGets(map.getLockWaitCount() + data.getLockWaits());
                data.setGets(map.getNumberOfGets() + data.getGets());
                data.setPuts(map.getNumberOfPuts() + data.getPuts());
                data.setRemoves(map.getNumberOfRemoves() + data.getRemoves());
            }
            this.listData.add(data);
        }
        this.header.setTitle(queueName);
        Collections.sort(this.listData, new Comparator<Data>(){

            @Override
            public int compare(Data arg0, Data arg1) {
                return arg0.getTime().compareTo(arg1.getTime());
            }
        });
        this.queues.getUnderlyingTable().setRowData(this.listData);
        this.chartEntries.setLoaded(false);
        this.chartHits.setLoaded(false);
        this.chartLocked.setLoaded(false);
        this.chartWaits.setLoaded(false);
        this.chartGets.setLoaded(false);
        this.chartPuts.setLoaded(false);
        this.chartRemoves.setLoaded(false);
        this.mainTabPanel.selectTab(0, true);
    }

    private void loadChart(int selected) {
        if (selected == 0) {
            this.loadChart(this.entPanel, this.chartEntries);
        } else if (selected == 1) {
            this.loadChart(this.hitPanel, this.chartHits);
        } else if (selected == 2) {
            this.loadChart(this.lokPanel, this.chartLocked);
        } else if (selected == 3) {
            this.loadChart(this.waitPanel, this.chartWaits);
        } else if (selected == 4) {
            this.loadChart(this.getPanel, this.chartGets);
        } else if (selected == 5) {
            this.loadChart(this.putPanel, this.chartPuts);
        } else if (selected == 6) {
            this.loadChart(this.remPanel, this.chartRemoves);
        }
    }

    private void loadChart(VerticalPanel parent, TimeSeriesChart chart) {
        if (!chart.isLoaded()) {
            chart.setData(this.listData);
            if (parent.getWidgetCount() == 0) {
                parent.add(chart.asWidget());
            }
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth() - 6 - 6 - 1 - 1;
        int mainTabPanelHeight = 281;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            mainTabPanelHeight -= 33;
        }
        this.chartEntries.setWidth(chartWidth);
        this.chartHits.setWidth(chartWidth);
        this.chartLocked.setWidth(chartWidth);
        this.chartWaits.setWidth(chartWidth);
        this.chartGets.setWidth(chartWidth);
        this.chartPuts.setWidth(chartWidth);
        this.chartRemoves.setWidth(chartWidth);
        this.chartEntries.setHeight(240);
        this.chartHits.setHeight(240);
        this.chartLocked.setHeight(240);
        this.chartWaits.setHeight(240);
        this.chartGets.setHeight(240);
        this.chartPuts.setHeight(240);
        this.chartRemoves.setHeight(240);
        this.mainTabPanel.setWidth(Sizes.toString(this.getWidth()));
        this.mainTabPanel.setHeight(Sizes.toString(mainTabPanelHeight));
        int height = this.getHeight() - mainTabPanelHeight - 40;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            height -= 33;
        }
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
        this.header.setHeight(Sizes.toString(40));
        this.header.setWidth(Sizes.toString(this.getWidth()));
    }
}

