/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.queues;

import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.queues.BarChart;
import org.pepstock.jem.gwt.client.panels.administration.queues.Data;
import org.pepstock.jem.gwt.client.panels.administration.queues.QueuesTable;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;

public class OverviewPanel
extends AdminPanel
implements ResizeCapable {
    private BarChart chartEntries = new BarChart(0);
    private TableContainer<Data> queues = new TableContainer<Data>(new QueuesTable());
    private ScrollPanel scroller = new ScrollPanel(this.queues);
    private HashMap<String, Data> mapData = new HashMap();
    private InspectListener<Data> listener = null;
    private VerticalPanel entriesPanel = new VerticalPanel();

    public OverviewPanel() {
        this.add((Widget)this.entriesPanel);
        this.add((Widget)this.scroller);
    }

    public InspectListener<Data> getListener() {
        return this.listener;
    }

    public void setListener(InspectListener<Data> listener) {
        this.listener = listener;
        this.queues.getUnderlyingTable().setInspectListener(listener);
    }

    public void load() {
        this.mapData.clear();
        for (LightMemberSample msample : Instances.getLastSample().getMembers()) {
            if (msample == null) continue;
            for (LightMapStats map : msample.getMapsStats().values()) {
                if (map == null) continue;
                Data data = null;
                if (this.mapData.containsKey(map.getName())) {
                    data = this.mapData.get(map.getName());
                } else {
                    data = new Data();
                    data.setQueue(map.getName());
                    int lastDot = map.getName().lastIndexOf(46) + 1;
                    String key = map.getName().substring(lastDot);
                    data.setKey(key);
                    data.setTime(msample.getTime());
                }
                data.setEntries(map.getOwnedEntryCount() + data.getEntries());
                data.setGets(map.getNumberOfGets() + data.getGets());
                data.setPuts(map.getNumberOfPuts() + data.getPuts());
                data.setRemoves(map.getNumberOfRemoves() + data.getRemoves());
                data.setHits(map.getHits() + data.getHits());
                data.setLocked(map.getLockedEntryCount() + data.getLocked());
                data.setHits(map.getLockWaitCount() + data.getLockWaits());
                this.mapData.put(map.getName(), data);
            }
        }
        this.queues.getUnderlyingTable().setRowData(new ArrayList<Data>(this.mapData.values()));
        this.loadChart();
    }

    private void loadChart() {
        this.chartEntries.setData(new ArrayList<Data>(this.mapData.values()));
        if (this.entriesPanel.getWidgetCount() == 0) {
            this.entriesPanel.add(this.chartEntries.asWidget());
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth();
        this.chartEntries.setWidth(chartWidth);
        this.chartEntries.setHeight(240);
        int height = this.getHeight() - 240;
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
    }
}

