/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.panels.administration.nodessystem.inspector.NodesComparator;
import org.pepstock.jem.node.stats.LightMemberSample;

public class NodesTable
extends AbstractTable<LightMemberSample> {
    @Override
    public IndexedColumnComparator<LightMemberSample> initCellTable(CellTable<LightMemberSample> table) {
        TextColumn<LightMemberSample> name = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample object) {
                return object.getMemberLabel() + " - " + object.getMemberHostname();
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, "Name");
        TextColumn<LightMemberSample> time = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return memberSample.getTime();
            }
        };
        time.setSortable(true);
        table.addColumn((Column)time, "Time");
        TextColumn<LightMemberSample> machineCpu = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                double cpu = memberSample.getCpuPercent();
                String data = NumberFormat.getFormat((String)"##0.00").format(cpu * 100.0);
                return data + " %";
            }
        };
        machineCpu.setSortable(true);
        table.addColumn((Column)machineCpu, "Cpu");
        TextColumn<LightMemberSample> memoryAvail = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = NumberFormat.getFormat((String)"###,##0 MB").format((double)memberSample.getMemoryAvailable() / 1024.0 / 1024.0);
                return data;
            }
        };
        memoryAvail.setSortable(true);
        table.addColumn((Column)memoryAvail, "Memory available");
        TextColumn<LightMemberSample> memoryFree = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = NumberFormat.getFormat((String)"###,##0 MB").format((double)memberSample.getMemoryFree() / 1024.0 / 1024.0);
                return data;
            }
        };
        memoryFree.setSortable(true);
        table.addColumn((Column)memoryFree, "Memory free");
        TextColumn<LightMemberSample> processCpu = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                double cpu = memberSample.getProcessCpuPercent();
                String data = NumberFormat.getFormat((String)"##0.00").format(cpu * 100.0);
                return data + " %";
            }
        };
        processCpu.setSortable(true);
        table.addColumn((Column)processCpu, "Process Cpu");
        TextColumn<LightMemberSample> processCpuTotal = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = NumberFormat.getFormat((String)"###,###,##0 ms").format((double)memberSample.getProcessTotalCpu());
                return data;
            }
        };
        processCpuTotal.setSortable(true);
        table.addColumn((Column)processCpuTotal, "Process Cpu Total");
        TextColumn<LightMemberSample> processMemoryUsed = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = NumberFormat.getFormat((String)"###,##0 MB").format((double)memberSample.getProcessMemoryUsed() / 1024.0 / 1024.0);
                return data;
            }
        };
        processMemoryUsed.setSortable(true);
        table.addColumn((Column)processMemoryUsed, "Process Memory used");
        return new NodesComparator(0);
    }
}

