/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesqueues.inspector;

import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.BackListener;
import org.pepstock.jem.gwt.client.panels.administration.commons.InspectorHeader;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.nodesqueues.inspector.Data;
import org.pepstock.jem.gwt.client.panels.administration.nodesqueues.inspector.NodesTable;
import org.pepstock.jem.gwt.client.panels.administration.nodesqueues.inspector.TimeSeriesChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightMemberSampleComparator;
import org.pepstock.jem.node.stats.LightSample;

public class InspectorPanel
extends AdminPanel
implements ResizeCapable {
    final TabPanel mainTabPanel = new TabPanel();
    private TimeSeriesChart chartInput = new TimeSeriesChart(0);
    private TimeSeriesChart chartRunning = new TimeSeriesChart(1);
    private TimeSeriesChart chartOutput = new TimeSeriesChart(2);
    private TimeSeriesChart chartRouting = new TimeSeriesChart(3);
    private TableContainer<LightMemberSample> nodes = new TableContainer<LightMemberSample>(new NodesTable());
    private ScrollPanel scroller = new ScrollPanel(this.nodes);
    private InspectorHeader header = new InspectorHeader("Host:");
    private ArrayList<Data> listData = new ArrayList();
    private VerticalPanel inputPanel = new VerticalPanel();
    private VerticalPanel runningPanel = new VerticalPanel();
    private VerticalPanel outputPanel = new VerticalPanel();
    private VerticalPanel routingPanel = new VerticalPanel();

    public InspectorPanel() {
        this.mainTabPanel.add((Widget)this.inputPanel, "Input", false);
        this.mainTabPanel.add((Widget)this.runningPanel, "Running", false);
        this.mainTabPanel.add((Widget)this.outputPanel, "Output", false);
        this.mainTabPanel.add((Widget)this.routingPanel, "Routing", false);
        this.mainTabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                InspectorPanel.this.loadChart((Integer)event.getSelectedItem());
            }
        });
        this.add((Widget)this.header);
        this.add((Widget)this.mainTabPanel);
        this.add((Widget)this.scroller);
    }

    public BackListener getListener() {
        return this.header.getListener();
    }

    public void setListener(BackListener listener) {
        this.header.setListener(listener);
    }

    public void load(String memberKey) {
        this.listData.clear();
        ArrayList<LightMemberSample> list = new ArrayList<LightMemberSample>();
        boolean set = true;
        for (LightSample sample : Instances.getSamples()) {
            for (LightMemberSample msample : sample.getMembers()) {
                if (!msample.getMemberKey().equalsIgnoreCase(memberKey)) continue;
                Data data = new Data();
                data.setKey(sample.getTime());
                data.setInput(((LightMapStats)msample.getMapsStats().get("org.pepstock.jem.input")).getOwnedEntryCount());
                data.setRunning(((LightMapStats)msample.getMapsStats().get("org.pepstock.jem.running")).getOwnedEntryCount());
                data.setOutput(((LightMapStats)msample.getMapsStats().get("org.pepstock.jem.output")).getOwnedEntryCount());
                data.setRouting(((LightMapStats)msample.getMapsStats().get("org.pepstock.jem.routing")).getOwnedEntryCount());
                this.listData.add(data);
                list.add(msample);
                if (!set) continue;
                set = false;
                this.header.setTitle(msample.getMemberLabel() + " - " + msample.getMemberHostname());
            }
        }
        Collections.sort(list, new LightMemberSampleComparator());
        this.nodes.getUnderlyingTable().setRowData(list);
        this.chartInput.setLoaded(false);
        this.chartRunning.setLoaded(false);
        this.chartOutput.setLoaded(false);
        this.chartRouting.setLoaded(false);
        this.mainTabPanel.selectTab(0, true);
    }

    private void loadChart(int selected) {
        if (selected == 0) {
            this.loadChart(this.inputPanel, this.chartInput);
        } else if (selected == 1) {
            this.loadChart(this.runningPanel, this.chartRunning);
        } else if (selected == 2) {
            this.loadChart(this.outputPanel, this.chartOutput);
        } else if (selected == 3) {
            this.loadChart(this.routingPanel, this.chartRouting);
        }
    }

    private void loadChart(VerticalPanel parent, TimeSeriesChart chart) {
        if (!chart.isLoaded()) {
            chart.setData(this.listData);
            if (parent.getWidgetCount() == 0) {
                parent.add(chart.asWidget());
            }
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth() - 6 - 6 - 1 - 1;
        int mainTabPanelHeight = 281;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            mainTabPanelHeight -= 33;
        }
        this.chartInput.setWidth(chartWidth);
        this.chartRunning.setWidth(chartWidth);
        this.chartRouting.setWidth(chartWidth);
        this.chartOutput.setWidth(chartWidth);
        this.chartInput.setHeight(240);
        this.chartRunning.setHeight(240);
        this.chartOutput.setHeight(240);
        this.chartRouting.setHeight(240);
        this.mainTabPanel.setWidth(Sizes.toString(this.getWidth()));
        this.mainTabPanel.setHeight(Sizes.toString(mainTabPanelHeight));
        int height = this.getHeight() - mainTabPanelHeight - 40;
        if (Window.Navigator.getUserAgent().contains("MSIE 8")) {
            height -= 33;
        }
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
        this.header.setHeight(Sizes.toString(40));
        this.header.setWidth(Sizes.toString(this.getWidth()));
    }
}

