/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesqueues;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.panels.administration.nodesqueues.NodesComparator;
import org.pepstock.jem.node.stats.LightMapStats;
import org.pepstock.jem.node.stats.LightMemberSample;

public class NodesTable
extends AbstractTable<LightMemberSample> {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;

    @Override
    public IndexedColumnComparator<LightMemberSample> initCellTable(CellTable<LightMemberSample> table) {
        AnchorTextColumn<LightMemberSample> name = new AnchorTextColumn<LightMemberSample>(){

            @Override
            public String getValue(LightMemberSample object) {
                return object.getMemberLabel() + " - " + object.getMemberHostname();
            }

            @Override
            public void onClick(int index, LightMemberSample object, String value) {
                NodesTable.this.getInspectListener().inspect(object);
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, "Name");
        TextColumn<LightMemberSample> pid = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return String.valueOf(memberSample.getPid());
            }
        };
        table.addColumn((Column)pid, "PID");
        TextColumn<LightMemberSample> time = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return memberSample.getTime();
            }
        };
        table.addColumn((Column)time, "Time");
        TextColumn<LightMemberSample> inputEntries = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return NumberFormat.getFormat((String)"###,###,##0").format((double)((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.input")).getOwnedEntryCount());
            }
        };
        inputEntries.setSortable(true);
        table.addColumn((Column)inputEntries, "Input");
        TextColumn<LightMemberSample> inputMemoryCost = new TextColumn<LightMemberSample>(){
            private static final long KB = 1024L;
            private static final long MB = 0x100000L;

            public String getValue(LightMemberSample memberSample) {
                String data = null;
                long cost = ((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.input")).getOwnedEntryMemoryCost();
                data = cost < 0x100000L ? NumberFormat.getFormat((String)"#,##0 KB").format((double)(cost /= 1024L)) : NumberFormat.getFormat((String)"###,##0 MB").format((double)(cost /= 0x100000L));
                return data;
            }
        };
        inputMemoryCost.setSortable(true);
        table.addColumn((Column)inputMemoryCost, "Input Cost");
        TextColumn<LightMemberSample> runningEntries = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return NumberFormat.getFormat((String)"###,###,##0").format((double)((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.running")).getOwnedEntryCount());
            }
        };
        runningEntries.setSortable(true);
        table.addColumn((Column)runningEntries, "Running");
        TextColumn<LightMemberSample> runningMemoryCost = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = null;
                long cost = ((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.running")).getOwnedEntryMemoryCost();
                data = cost < 0x100000L ? NumberFormat.getFormat((String)"#,##0 KB").format((double)(cost /= 1024L)) : NumberFormat.getFormat((String)"###,##0 MB").format((double)(cost /= 0x100000L));
                return data;
            }
        };
        runningMemoryCost.setSortable(true);
        table.addColumn((Column)runningMemoryCost, "Running Cost");
        TextColumn<LightMemberSample> outputEntries = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return NumberFormat.getFormat((String)"###,###,##0").format((double)((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.output")).getOwnedEntryCount());
            }
        };
        outputEntries.setSortable(true);
        table.addColumn((Column)outputEntries, "Output");
        TextColumn<LightMemberSample> outputMemoryCost = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = null;
                long cost = ((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.output")).getOwnedEntryMemoryCost();
                data = cost < 0x100000L ? NumberFormat.getFormat((String)"#,##0 KB").format((double)(cost /= 1024L)) : NumberFormat.getFormat((String)"###,##0 MB").format((double)(cost /= 0x100000L));
                return data;
            }
        };
        outputMemoryCost.setSortable(true);
        table.addColumn((Column)outputMemoryCost, "Output Cost");
        TextColumn<LightMemberSample> routingEntries = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                return NumberFormat.getFormat((String)"###,###,##0").format((double)((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.routing")).getOwnedEntryCount());
            }
        };
        routingEntries.setSortable(true);
        table.addColumn((Column)routingEntries, "Routing");
        TextColumn<LightMemberSample> routingMemoryCost = new TextColumn<LightMemberSample>(){

            public String getValue(LightMemberSample memberSample) {
                String data = null;
                long cost = ((LightMapStats)memberSample.getMapsStats().get("org.pepstock.jem.routing")).getOwnedEntryMemoryCost();
                data = cost < 0x100000L ? NumberFormat.getFormat((String)"#,##0 KB").format((double)(cost /= 1024L)) : NumberFormat.getFormat((String)"###,##0 MB").format((double)(cost /= 0x100000L));
                return data;
            }
        };
        routingMemoryCost.setSortable(true);
        table.addColumn((Column)routingMemoryCost, "Routing Cost");
        return new NodesComparator(0);
    }
}

