/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig.commands;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.CommandExecutor;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.ResultPanel;
import org.pepstock.jem.gwt.client.services.Services;

public class ViewClusterCommand
extends CommandExecutor {
    private static final int VIEW_CLUSTER = 2;
    private static final String LABEL = "View Cluster";
    private static final String TITLE = "List of JEM cluster members";

    public ViewClusterCommand() {
        this.setIndex(2);
        this.setTitle(TITLE);
        this.setLabel(LABEL);
    }

    @Override
    public void execute(final NodeInfoBean node, final ResultPanel resultPanel) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.displayCluster(node, new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        ViewClusterCommand.this.getLoading().stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "View cluster error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(String result) {
                        if (result != null) {
                            resultPanel.setResult(result);
                            ViewClusterCommand.this.getLoading().stopProcessing();
                        } else {
                            ViewClusterCommand.this.getLoading().stopProcessing();
                            AlertMessageBox alert = new AlertMessageBox(1, "View cluster  warning!", "View cluster result is null. <br>Please have a look to JEM node log");
                            alert.open();
                        }
                    }
                });
            }
        });
    }
}

