/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.nodesconfig;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.ConfigXmlViewer;
import org.pepstock.jem.gwt.client.services.Services;

public class ConfigPanel
extends VerticalPanel
implements ResizeCapable,
InspectListener<NodeInfoBean> {
    private static final String JEM_ID = "jemEditorID";
    private static final String HAZELCAST_ID = "hcEditorID";
    private final Loading loading = new Loading();
    private TabPanel tabPanel = new TabPanel();
    private ConfigXmlViewer jem = new ConfigXmlViewer("jemEditorID");
    private ConfigXmlViewer hazelcast = new ConfigXmlViewer("hcEditorID");
    private NodeInfoBean node = null;

    public ConfigPanel() {
        this.tabPanel.add((Widget)this.jem, "Jem");
        this.tabPanel.add((Widget)this.hazelcast, "Hazelcast");
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                if (!ConfigPanel.this.tabPanel.isVisible()) {
                    ConfigPanel.this.tabPanel.setVisible(true);
                }
                ConfigPanel.this.inspect((Integer)event.getSelectedItem());
            }
        });
        this.tabPanel.setVisible(false);
        this.add((Widget)this.tabPanel);
    }

    @Override
    public void inspect(NodeInfoBean object) {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.jem.setContent(null);
        this.jem.destroyEditor();
        this.hazelcast.setContent(null);
        this.hazelcast.destroyEditor();
        this.node = object;
        this.tabPanel.selectTab(0, true);
    }

    @Override
    private void inspect(final int what) {
        if (what == 0 ? this.jem.getContent() != null : this.hazelcast.getContent() != null) {
            return;
        }
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getConfigFile(ConfigPanel.this.node, what == 0 ? "jem.config" : "hazelcast.config", new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        ConfigPanel.this.loading.stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(String result) {
                        if (result != null) {
                            if (what == 0) {
                                ConfigPanel.this.jem.setContent(result);
                                ConfigPanel.this.jem.startEditor();
                            } else {
                                ConfigPanel.this.hazelcast.setContent(result);
                                ConfigPanel.this.hazelcast.startEditor();
                            }
                            ConfigPanel.this.loading.stopProcessing();
                        } else {
                            ConfigPanel.this.loading.stopProcessing();
                            AlertMessageBox alert = new AlertMessageBox(2, "Get CONFIG file null!", "The result, while retrieving the configuration file, is null,");
                            alert.open();
                        }
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.tabPanel.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
        int syntaxHighlighterHeight = availableHeight - 33 - 4 - 2 - 2;
        int syntaxHighlighterWidth = availableWidth - 4 - 4 - 2 - 2;
        this.jem.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
        this.hazelcast.onResize(syntaxHighlighterWidth, syntaxHighlighterHeight);
    }
}

