/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.memory;

import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.panels.administration.memory.Data;
import org.pepstock.jem.gwt.client.panels.administration.memory.Detail;
import org.pepstock.jem.gwt.client.panels.administration.memory.MemoryTable;
import org.pepstock.jem.gwt.client.panels.administration.memory.PieChart;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.node.stats.LightMemberSample;
import org.pepstock.jem.node.stats.LightSample;

public class OverviewPanel
extends AdminPanel
implements ResizeCapable {
    private PieChart chart = new PieChart();
    private TableContainer<Detail> gfs = new TableContainer<Detail>(new MemoryTable());
    private ScrollPanel scroller = new ScrollPanel(this.gfs);
    private LinkedList<Data> mapData = new LinkedList();
    private VerticalPanel entriesPanel = new VerticalPanel();

    public OverviewPanel() {
        this.add((Widget)this.entriesPanel);
        this.add((Widget)this.scroller);
    }

    public void load() {
        this.mapData.clear();
        Data dataFree = new Data();
        dataFree.setKey("Free");
        Data dataUsed = new Data();
        dataUsed.setKey("Used");
        long free = 0L;
        long used = 0L;
        for (LightMemberSample msample : Instances.getLastSample().getMembers()) {
            if (msample == null) continue;
            free += msample.getProcessMemoryFree();
            used += msample.getProcessMemoryUsed();
        }
        long tot = free + used;
        dataFree.setValue(free);
        dataFree.setPercent((double)free / (double)tot);
        dataUsed.setValue(used);
        dataUsed.setPercent((double)used / (double)tot);
        this.mapData.addFirst(dataFree);
        this.mapData.addLast(dataUsed);
        ArrayList<Detail> list = new ArrayList<Detail>();
        for (LightSample sample : Instances.getSamples()) {
            Detail detail = new Detail();
            detail.setKey(sample.getKey());
            detail.setTime(sample.getTime());
            tot = 0L;
            free = 0L;
            used = 0L;
            for (LightMemberSample msample : sample.getMembers()) {
                free += msample.getProcessMemoryFree();
                used += msample.getProcessMemoryUsed();
            }
            tot = free + used;
            detail.setFree(free);
            detail.setFreePercent((double)free / (double)tot);
            detail.setUsed(used);
            detail.setUsedPercent((double)used / (double)tot);
            list.add(detail);
        }
        Collections.sort(list, new Comparator<Detail>(){

            @Override
            public int compare(Detail o1, Detail o2) {
                return o1.getKey().compareTo(o2.getKey()) * -1;
            }
        });
        this.gfs.getUnderlyingTable().setRowData(list);
        this.loadChart();
    }

    private void loadChart() {
        this.chart.setData(this.mapData);
        if (this.entriesPanel.getWidgetCount() == 0) {
            this.entriesPanel.add(this.chart.asWidget());
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int chartWidth = this.getWidth();
        this.chart.setWidth(chartWidth);
        this.chart.setHeight(240);
        int height = this.getHeight() - 240;
        height = Math.max(height, 1);
        this.scroller.setHeight(Sizes.toString(height));
        this.scroller.setWidth(Sizes.toString(this.getWidth()));
    }
}

