/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.certificates;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import java.util.Collection;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.panels.administration.certificates.CertificateAdder;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.CertificateEntry;

public class CertificateEntryActions
extends AbstractActionsButtonPanel<CertificateEntry> {
    public CertificateEntryActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addAddButton();
        this.addDeleteButton();
    }

    private void addAddButton() {
        if (ClientPermissions.isAuthorized("certificates", "certificates:create")) {
            Button releaseButton = new Button("Add", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)CertificateEntryActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    selectionModel.clear();
                    CertificateAdder inspector = new CertificateAdder();
                    inspector.setWidth("600px");
                    inspector.setHeight("240px");
                    inspector.setModal(true);
                    inspector.setTitle("Add new Certificate");
                    inspector.center();
                    inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> arg0) {
                            if (CertificateEntryActions.this.getSearcher() != null) {
                                CertificateEntryActions.this.getSearcher().refresh();
                            }
                        }
                    });
                }
            });
            this.add((Widget)releaseButton);
        }
    }

    private void addDeleteButton() {
        if (ClientPermissions.isAuthorized("certificates", "certificates:delete")) {
            Button removeButton = new Button("Remove", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)CertificateEntryActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No Certificate selected!", "No certificate is selected and it's not possible to perform REMOVE command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm REMOVE", "Are you sure you want to remove the selected certificates?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                CertificateEntryActions.this.remove(selectionModel.getSelectedSet());
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)removeButton);
        }
    }

    public void remove(final Collection<CertificateEntry> entries) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.CERTIFICATES_MANAGER.removeCertificates(entries, new AsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        CertificateEntryActions.this.getLoading().stopProcessing();
                        if (CertificateEntryActions.this.getSearcher() != null) {
                            CertificateEntryActions.this.getSearcher().refresh();
                        }
                    }

                    public void onFailure(Throwable caught) {
                        CertificateEntryActions.this.getLoading().stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Remove certificates command error!", caught.getMessage());
                        alert.open();
                    }
                });
            }
        });
    }
}

