/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration.certificates;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.panels.administration.certificates.CertificateEntriesComparator;
import org.pepstock.jem.node.security.CertificateEntry;

public class CertificateEntriesTable
extends AbstractTable<CertificateEntry> {
    @Override
    public IndexedColumnComparator<CertificateEntry> initCellTable(CellTable<CertificateEntry> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<CertificateEntry, Boolean> checkColumn = new Column<CertificateEntry, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(CertificateEntry entry) {
                return selectionModel.isSelected((Object)entry);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (CertificateEntriesTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (CertificateEntry entry : CertificateEntriesTable.this.getTable().getVisibleItems()) {
                    if (CertificateEntriesTable.this.getTable().getSelectionModel().isSelected((Object)entry)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (CertificateEntry entry : CertificateEntriesTable.this.getTable().getVisibleItems()) {
                    CertificateEntriesTable.this.getTable().getSelectionModel().setSelected((Object)entry, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        TextColumn<CertificateEntry> name = new TextColumn<CertificateEntry>(){

            public String getValue(CertificateEntry object) {
                return object.getAlias();
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, "Alias");
        TextColumn<CertificateEntry> principal = new TextColumn<CertificateEntry>(){

            public String getValue(CertificateEntry entry) {
                return String.valueOf(entry.getIssuer());
            }
        };
        table.addColumn((Column)principal, "Issuer");
        TextColumn<CertificateEntry> subject = new TextColumn<CertificateEntry>(){

            public String getValue(CertificateEntry entry) {
                return String.valueOf(entry.getSubject());
            }
        };
        table.addColumn((Column)subject, "Subject");
        TextColumn<CertificateEntry> begin = new TextColumn<CertificateEntry>(){

            public String getValue(CertificateEntry entry) {
                if (entry.getNotBefore() == null) {
                    return "";
                }
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(entry.getNotBefore());
            }
        };
        begin.setSortable(true);
        table.addColumn((Column)begin, "Valid Not Before");
        TextColumn<CertificateEntry> after = new TextColumn<CertificateEntry>(){

            public String getValue(CertificateEntry entry) {
                if (entry.getNotAfter() == null) {
                    return "";
                }
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(entry.getNotAfter());
            }
        };
        after.setSortable(true);
        table.addColumn((Column)after, "Valid Not After");
        return new CertificateEntriesComparator(0);
    }
}

