/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.security.ClientPermissions;

public class TreeOptions
extends ScrollPanel {
    public static final String WORKLOAD_JOBS_OPTION = "workload-jobs";
    public static final String CURRENT_QUEUES_STATUS_OPTION = "current-queues-status";
    public static final String QUEUES_STATUS_OPTION = "queues-status";
    public static final String INTERNAL_MAPS_OPTION = "internal_maps";
    public static final String SECRET_UTILITY_OPTION = "secret-utility";
    public static final String NODES_SYSTEM_STATUS_OPTION = "nodes-system-status";
    public static final String NODES_QUEUES_STATUS_OPTION = "nodes-queues-status";
    public static final String GRS_CONTENTIONS_OPTION = "grs-contentions";
    public static final String NODES_CONFIG_OPTION = "nodes-configuration";
    public static final String NODES_COMMANDS_OPTION = "nodes-commands";
    public static final String REDO_PANEL_OPTION = "redo-panel";
    public static final String GFS_PANEL_OPTION = "gfs-panel";
    public static final String MEMORY_PANEL_OPTION = "memory-panel";
    public static final String CERTIFICATES_PANEL_OPTION = "certificate-panel";
    private InspectListener<String> listener = null;
    private CellPanel selected = null;

    public TreeOptions() {
        this.setWidth("100%");
        this.setHeight("100%");
        CellPanel nconfig = this.createItem("Configuration", NODES_CONFIG_OPTION, null, "administration:nodes:configuration");
        CellPanel ncmd = this.createItem("Commands", NODES_COMMANDS_OPTION, null, "administration:nodes:commands");
        CellPanel grs = this.createItem("Resources contention", GRS_CONTENTIONS_OPTION, null, "administration:cluster:grs");
        CellPanel secret = this.createItem("Secret utility", SECRET_UTILITY_OPTION, null, "administration:security:secret");
        CellPanel cqueues = this.createItem("Current Status", CURRENT_QUEUES_STATUS_OPTION, null, "administration:queues:current");
        CellPanel internals = this.createItem("Current Internals", INTERNAL_MAPS_OPTION, null, "administration:queues:internalMaps");
        CellPanel jobs = this.createItem("Jobs Workload", WORKLOAD_JOBS_OPTION, null, "administration:cluster:workload");
        CellPanel queues = this.createItem("Statistics", QUEUES_STATUS_OPTION, null, "administration:queues:statistics");
        CellPanel nsystem = this.createItem("System status", NODES_SYSTEM_STATUS_OPTION, null, "administration:nodes:system");
        CellPanel nqueues = this.createItem("Queues status", NODES_QUEUES_STATUS_OPTION, null, "administration:nodes:queues");
        CellPanel redo = this.createItem("Redo statements", REDO_PANEL_OPTION, null, "administration:cluster:redo");
        CellPanel gfs = this.createItem("GFS usage", GFS_PANEL_OPTION, null, "administration:cluster:gfs-usage");
        CellPanel memory = this.createItem("Memory usage", MEMORY_PANEL_OPTION, null, "administration:cluster:memory-usage");
        CellPanel certificate = this.createItem("Certificates manager", CERTIFICATES_PANEL_OPTION, null, "administration:security:certificate");
        LinkedList<CellPanel> panels = new LinkedList<CellPanel>();
        LinkedList<DisclosurePanel> dPanels = new LinkedList<DisclosurePanel>();
        if (ClientPermissions.isAuthorized("administration", "administration:cluster:folder")) {
            if (jobs != null) {
                panels.add(jobs);
            }
            if (gfs != null) {
                panels.add(gfs);
            }
            if (memory != null) {
                panels.add(memory);
            }
            if (grs != null) {
                panels.add(grs);
            }
            if (redo != null) {
                panels.add(redo);
            }
            if (!panels.isEmpty()) {
                dPanels.add(this.createContainer("Cluster", Images.INSTANCE.planet_24(), panels.toArray(new CellPanel[0])));
            }
        }
        panels.clear();
        if (ClientPermissions.isAuthorized("administration", "administration:nodes:folder")) {
            if (nconfig != null) {
                panels.add(nconfig);
            }
            if (ncmd != null) {
                panels.add(ncmd);
            }
            if (nsystem != null) {
                panels.add(nsystem);
            }
            if (nqueues != null) {
                panels.add(nqueues);
            }
            if (!panels.isEmpty()) {
                dPanels.add(this.createContainer("Nodes", Images.INSTANCE.networkPc_24(), panels.toArray(new CellPanel[0])));
            }
        }
        panels.clear();
        if (ClientPermissions.isAuthorized("administration", "administration:queues:folder")) {
            if (cqueues != null) {
                panels.add(cqueues);
            }
            if (queues != null) {
                panels.add(queues);
            }
            if (internals != null) {
                panels.add(internals);
            }
            if (!panels.isEmpty()) {
                dPanels.add(this.createContainer("Queues", Images.INSTANCE.list_24(), panels.toArray(new CellPanel[0])));
            }
        }
        panels.clear();
        if (ClientPermissions.isAuthorized("administration", "administration:security:folder")) {
            if (certificate != null) {
                panels.add(certificate);
            }
            if (secret != null) {
                panels.add(secret);
            }
            if (!panels.isEmpty()) {
                dPanels.add(this.createContainer("Security", Images.INSTANCE.key_24(), panels.toArray(new CellPanel[0])));
            }
        }
        Grid grid = new Grid(dPanels.size(), 1);
        int index = 0;
        for (DisclosurePanel panel : dPanels) {
            grid.setWidget(index, 0, (Widget)panel);
            ++index;
        }
        this.add((Widget)grid);
    }

    public void setListener(InspectListener<String> listener) {
        this.listener = listener;
    }

    private void selectPanel(CellPanel select) {
        if (select.equals(this.selected)) {
            return;
        }
        if (this.selected != null) {
            this.selected.setStyleName(Styles.INSTANCE.common().adminUnselectedTreeItem());
        }
        select.setStyleName(Styles.INSTANCE.common().adminSelectedTreeItem());
        this.selected = select;
    }

    private final CellPanel createItem(String description, final String option, ImageResource icon, String permission) {
        if (!ClientPermissions.isAuthorized("administration", permission)) {
            return null;
        }
        final HorizontalPanel options = new HorizontalPanel();
        options.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        options.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        options.setSpacing(8);
        options.setWidth("100%");
        Anchor anchor = new Anchor(description);
        anchor.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TreeOptions.this.listener != null) {
                    TreeOptions.this.listener.inspect(option);
                    TreeOptions.this.selectPanel((CellPanel)options);
                }
            }
        });
        if (icon != null) {
            options.add((Widget)new Image(icon));
        }
        options.add((Widget)anchor);
        options.setCellWidth((Widget)anchor, "100%");
        return options;
    }

    private final DisclosurePanel createContainer(String label, ImageResource icon, CellPanel ... panels) {
        HorizontalPanel header = new HorizontalPanel();
        header.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
        header.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        header.setSpacing(8);
        if (icon != null) {
            header.add((Widget)new Image(icon));
        }
        header.add((Widget)new Label(label));
        DisclosurePanel disclosure = new DisclosurePanel();
        disclosure.setHeader((Widget)header);
        disclosure.setAnimationEnabled(true);
        VerticalPanel panel = new VerticalPanel();
        for (int i = 0; i < panels.length; ++i) {
            panel.add((Widget)panels[i]);
        }
        disclosure.setContent((Widget)panel);
        return disclosure;
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

