/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.NodesSearcher;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.ConfigPanel;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.NodesList;
import org.pepstock.jem.gwt.client.services.Services;

public class NodesConfigPanel
extends AdminPanel
implements SearchListener,
ResizeCapable {
    private final Loading loading = new Loading();
    private NodesSearcher searcher = new NodesSearcher("administration.nodes.configuration");
    private HorizontalPanel secondRow = new HorizontalPanel();
    private NodesList list = new NodesList();
    private ConfigPanel config = new ConfigPanel();

    public NodesConfigPanel() {
        this.add((Widget)this.searcher);
        this.searcher.setSearchListener(this);
        this.list.setListener(this.config);
        this.secondRow.setSpacing(4);
        this.secondRow.add((Widget)this.list);
        this.secondRow.add((Widget)this.config);
        this.config.setVisible(false);
        this.add((Widget)this.secondRow);
    }

    public void load() {
    }

    public NodesList getList() {
        return this.list;
    }

    @Override
    public void search(final String filter) {
        this.config.setVisible(false);
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getNodes(filter, new AsyncCallback<Collection<NodeInfoBean>>(){

                    public void onFailure(Throwable caught) {
                        NodesConfigPanel.this.loading.stopProcessing();
                        NodesConfigPanel.this.searcher.setEnabled(true);
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(Collection<NodeInfoBean> result) {
                        NodesConfigPanel.this.list.setRowData(result);
                        NodesConfigPanel.this.loading.stopProcessing();
                        NodesConfigPanel.this.searcher.setEnabled(true);
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int height = this.getHeight() - 44 - 4 - 4;
        this.list.setSize(Sizes.toString(250), Sizes.toString(height));
        this.list.onResize(250, height);
        int configWidth = this.getWidth() - 250 - 4 - 4 - 4;
        this.config.setSize(Sizes.toString(configWidth), Sizes.toString(height));
        this.config.onResize(configWidth, height);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

