/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.administration;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.administration.commons.AdminPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.NodesSearcher;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.CommandExecutor;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.NodesList;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.commands.LogCommand;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.commands.TopCommand;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.commands.ViewClusterCommand;
import org.pepstock.jem.gwt.client.panels.administration.nodesconfig.nodescommand.CommandResultPanel;
import org.pepstock.jem.gwt.client.services.Services;

public class NodesCommandsPanel
extends AdminPanel
implements SearchListener,
InspectListener<NodeInfoBean>,
ResizeCapable {
    public static final ArrayList<CommandExecutor> COMMANDS;
    private int currentCommandExecutor = 0;
    private final Loading loading = new Loading();
    private NodesSearcher searcher = new NodesSearcher("administration.nodes.commands");
    private HorizontalPanel secondRow = new HorizontalPanel();
    private NodesList list = new NodesList();
    private CommandResultPanel resultPanel = new CommandResultPanel(this);

    public NodesCommandsPanel() {
        this.add((Widget)this.searcher);
        this.searcher.setSearchListener(this);
        this.list.setListener(this);
        this.secondRow.setSpacing(4);
        this.secondRow.add((Widget)this.list);
        this.secondRow.add((Widget)this.resultPanel);
        this.resultPanel.setVisible(false);
        this.add((Widget)this.secondRow);
    }

    public void load() {
    }

    public NodesList getList() {
        return this.list;
    }

    @Override
    public void search(final String filter) {
        this.resultPanel.setVisible(false);
        this.searcher.setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.NODES_MANAGER.getNodes(filter, new AsyncCallback<Collection<NodeInfoBean>>(){

                    public void onFailure(Throwable caught) {
                        NodesCommandsPanel.this.loading.stopProcessing();
                        NodesCommandsPanel.this.searcher.setEnabled(true);
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(Collection<NodeInfoBean> result) {
                        NodesCommandsPanel.this.list.setRowData(result);
                        NodesCommandsPanel.this.loading.stopProcessing();
                        NodesCommandsPanel.this.searcher.setEnabled(true);
                    }
                });
            }
        });
    }

    public void execute(NodeInfoBean object, int command) {
        for (CommandExecutor executor : COMMANDS) {
            if (executor.getIndex() != command) continue;
            this.currentCommandExecutor = command;
            executor.execute(object, this.resultPanel);
        }
        this.resultPanel.setVisible(true);
    }

    @Override
    public void inspect(NodeInfoBean object) {
        this.execute(object, this.currentCommandExecutor);
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        int height = this.getHeight() - 44 - 4 - 4;
        this.list.setSize(Sizes.toString(250), Sizes.toString(height));
        this.list.onResize(250, height);
        int resultWidth = this.getWidth() - 250 - 4 - 4 - 4;
        this.resultPanel.setSize(Sizes.toString(resultWidth), Sizes.toString(height));
        this.resultPanel.onResize(resultWidth, height);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        COMMANDS = new ArrayList();
        COMMANDS.add(new LogCommand());
        COMMANDS.add(new TopCommand());
        COMMANDS.add(new ViewClusterCommand());
    }
}

