/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import java.util.Collection;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.swarm.NodesActions;
import org.pepstock.jem.gwt.client.panels.swarm.NodesSearcher;
import org.pepstock.jem.gwt.client.panels.swarm.NodesTable;
import org.pepstock.jem.gwt.client.panels.swarm.commons.NodeInfoInspector;
import org.pepstock.jem.gwt.client.services.Services;

public class Swarm
extends BasePanel<NodeInfoBean>
implements SearchListener,
InspectListener<NodeInfoBean> {
    private final Loading loading = new Loading();

    public Swarm() {
        super(new TableContainer<NodeInfoBean>(new NodesTable()), new CommandPanel<NodeInfoBean>(new NodesSearcher(), new NodesActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        this.getCommandPanel().getActions().getUnderlyingTable().setInspectListener(this);
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String filter) {
        this.getCommandPanel().getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.SWARM_NODES_MANAGER.getNodesByFilter(filter, new AsyncCallback<Collection<NodeInfoBean>>(){

                    public void onFailure(Throwable caught) {
                        Swarm.this.loading.stopProcessing();
                        Swarm.this.getCommandPanel().getSearcher().setEnabled(true);
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                        Swarm.this.getCommandPanel().getSearcher().setFirstSearch(true);
                    }

                    public void onSuccess(Collection<NodeInfoBean> result) {
                        Swarm.this.getTableContainer().getUnderlyingTable().setRowData(result);
                        Swarm.this.loading.stopProcessing();
                        Swarm.this.getCommandPanel().getSearcher().setEnabled(true);
                        Swarm.this.getCommandPanel().getSearcher().setFirstSearch(false);
                        NodesActions na = (NodesActions)Swarm.this.getCommandPanel().getActions();
                        na.getStatus();
                    }
                });
            }
        });
    }

    @Override
    public void inspect(NodeInfoBean object) {
        try {
            NodeInfoInspector inspector = new NodeInfoInspector(object);
            inspector.setWidth(Sizes.toString(Window.getClientWidth() * 3 / 4));
            inspector.setHeight(Sizes.toString(Window.getClientHeight() * 3 / 4));
            inspector.setModal(true);
            inspector.setTitle(object.getLabel());
            inspector.center();
            inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                public void onClose(CloseEvent<PopupPanel> arg0) {
                }
            });
        }
        catch (Exception e) {
            AlertMessageBox alert = new AlertMessageBox(2, "Inspect error!", e.getMessage());
            alert.open();
        }
    }
}

