/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import java.util.Collection;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.roles.RoleInspector;
import org.pepstock.jem.gwt.client.panels.roles.RolesActions;
import org.pepstock.jem.gwt.client.panels.roles.RolesSearcher;
import org.pepstock.jem.gwt.client.panels.roles.RolesTable;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.Role;

public class Roles
extends BasePanel<Role>
implements SearchListener,
InspectListener<Role> {
    private final Loading loading = new Loading();

    public Roles() {
        super(new TableContainer<Role>(new RolesTable()), new CommandPanel<Role>(new RolesSearcher(), new RolesActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        this.getTableContainer().getUnderlyingTable().setInspectListener(this);
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String filter) {
        if (ClientPermissions.isAuthorized("roles", "roles:read")) {
            this.getCommandPanel().getSearcher().setEnabled(false);
            this.loading.startProcessing();
            Scheduler scheduler = Scheduler.get();
            scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Services.ROLES_MANAGER.getRoles(filter, new AsyncCallback<Collection<Role>>(){

                        public void onFailure(Throwable caught) {
                            Roles.this.loading.stopProcessing();
                            Roles.this.getCommandPanel().getSearcher().setEnabled(true);
                            AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                            alert.open();
                            Roles.this.getCommandPanel().getSearcher().setFirstSearch(true);
                        }

                        public void onSuccess(Collection<Role> result) {
                            Roles.this.getTableContainer().getUnderlyingTable().setRowData(result);
                            Roles.this.loading.stopProcessing();
                            Roles.this.getCommandPanel().getSearcher().setEnabled(true);
                            Roles.this.getCommandPanel().getSearcher().setFirstSearch(false);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void inspect(Role role) {
        if (ClientPermissions.isAuthorized("roles", "roles:update")) {
            RoleInspector inspector = new RoleInspector(role);
            inspector.setTitle(role.getName());
            inspector.center();
            inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                public void onClose(CloseEvent<PopupPanel> arg0) {
                    Roles.this.getCommandPanel().getSearcher().refresh();
                }
            });
        }
    }
}

