/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import java.util.Collection;
import org.pepstock.jem.Job;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.commons.UpdateListener;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobInspector;
import org.pepstock.jem.gwt.client.panels.jobs.commons.JobsSearcher;
import org.pepstock.jem.gwt.client.panels.jobs.input.InputActions;
import org.pepstock.jem.gwt.client.panels.jobs.input.InputTable;
import org.pepstock.jem.gwt.client.services.Services;

public class Input
extends BasePanel<Job>
implements SearchListener,
UpdateListener<Job> {
    private final Loading loading = new Loading();

    public Input() {
        super(new TableContainer<Job>(new InputTable(true)), new CommandPanel<Job>(new JobsSearcher("job.search.input"), new InputActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        this.getTableContainer().getUnderlyingTable().setInspectListener(this);
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String jobsFilter) {
        this.getCommandPanel().getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getInputQueue(jobsFilter, new AsyncCallback<Collection<Job>>(){

                    public void onFailure(Throwable caught) {
                        Input.this.loading.stopProcessing();
                        Input.this.getCommandPanel().getSearcher().setEnabled(true);
                        Input.this.getCommandPanel().getSearcher().setFirstSearch(true);
                        AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                        alert.open();
                        Input.this.getCommandPanel().getSearcher().setFirstSearch(true);
                    }

                    public void onSuccess(Collection<Job> result) {
                        Input.this.getTableContainer().getUnderlyingTable().setRowData(result);
                        Input.this.loading.stopProcessing();
                        Input.this.getCommandPanel().getSearcher().setEnabled(true);
                        Input.this.getCommandPanel().getSearcher().setFirstSearch(false);
                    }
                });
            }
        });
    }

    @Override
    public void inspect(final Job job) {
        this.getCommandPanel().getSearcher().setEnabled(false);
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.QUEUES_MANAGER.getJcl(job, "org.pepstock.jem.input", new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        Input.this.loading.stopProcessing();
                        Input.this.getCommandPanel().getSearcher().setEnabled(true);
                        AlertMessageBox alert = new AlertMessageBox(2, "Get JCL error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(String result) {
                        Input.this.loading.stopProcessing();
                        Input.this.getCommandPanel().getSearcher().setEnabled(true);
                        job.getJcl().setContent(result);
                        JobInspector inspector = new JobInspector(job);
                        inspector.setModal(true);
                        inspector.setTitle(job.getName());
                        inspector.center();
                        inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                            public void onClose(CloseEvent<PopupPanel> arg0) {
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public void update(final Job job) {
        if (job != null) {
            this.getCommandPanel().getSearcher().setEnabled(false);
            this.loading.startProcessing();
            Scheduler scheduler = Scheduler.get();
            scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Services.QUEUES_MANAGER.update(job, "org.pepstock.jem.input", new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            Input.this.loading.stopProcessing();
                            Input.this.getCommandPanel().getSearcher().setEnabled(true);
                            AlertMessageBox alert = new AlertMessageBox(2, "Update JOB error!", caught.getMessage());
                            alert.open();
                        }

                        public void onSuccess(Boolean result) {
                            Input.this.loading.stopProcessing();
                            Input.this.getCommandPanel().getSearcher().setEnabled(true);
                            Input.this.getCommandPanel().getSearcher().refresh();
                        }
                    });
                }
            });
        } else {
            this.getCommandPanel().getSearcher().refresh();
        }
    }
}

