/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.PopupPanel;
import java.util.Collection;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.SearchListener;
import org.pepstock.jem.gwt.client.events.EventBus;
import org.pepstock.jem.gwt.client.events.FilterEvent;
import org.pepstock.jem.gwt.client.events.FilterEventHandler;
import org.pepstock.jem.gwt.client.panels.components.BasePanel;
import org.pepstock.jem.gwt.client.panels.components.CommandPanel;
import org.pepstock.jem.gwt.client.panels.components.TableContainer;
import org.pepstock.jem.gwt.client.panels.resources.ResourceInspector;
import org.pepstock.jem.gwt.client.panels.resources.ResourcesActions;
import org.pepstock.jem.gwt.client.panels.resources.ResourcesSearcher;
import org.pepstock.jem.gwt.client.panels.resources.ResourcesTable;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.Resource;

public class CommonResources
extends BasePanel<Resource>
implements SearchListener,
InspectListener<Resource> {
    private final Loading loading = new Loading();

    public CommonResources() {
        super(new TableContainer<Resource>(new ResourcesTable()), new CommandPanel<Resource>(new ResourcesSearcher(), new ResourcesActions()));
        this.getCommandPanel().getSearcher().setSearchListener(this);
        this.getCommandPanel().getActions().setUnderlyingTable(this.getTableContainer().getUnderlyingTable());
        this.getTableContainer().getUnderlyingTable().setInspectListener(this);
        EventBus.INSTANCE.addHandler(FilterEvent.TYPE, (EventHandler)((FilterEventHandler)((Object)this.getCommandPanel().getSearcher())));
    }

    @Override
    public void search(final String filter) {
        if (ClientPermissions.isAuthorized("resources", "resources:read")) {
            this.loading.startProcessing();
            Scheduler scheduler = Scheduler.get();
            scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Services.COMMON_RESOURCES_MANAGER.getCommonResources(filter, new AsyncCallback<Collection<Resource>>(){

                        public void onFailure(Throwable caught) {
                            CommonResources.this.loading.stopProcessing();
                            AlertMessageBox alert = new AlertMessageBox(2, "Search error!", caught.getMessage());
                            alert.open();
                            CommonResources.this.getCommandPanel().getSearcher().setFirstSearch(true);
                        }

                        public void onSuccess(Collection<Resource> result) {
                            CommonResources.this.getTableContainer().getUnderlyingTable().setRowData(result);
                            CommonResources.this.loading.stopProcessing();
                            CommonResources.this.getCommandPanel().getSearcher().setFirstSearch(false);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void inspect(Resource resource) {
        if (ClientPermissions.isAuthorized("resources", "resources:update")) {
            ResourceInspector inspector = new ResourceInspector(resource);
            inspector.setTitle(resource.getName());
            inspector.center();
            inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                public void onClose(CloseEvent<PopupPanel> event) {
                    CommonResources.this.getCommandPanel().getSearcher().refresh();
                }
            });
        }
    }
}

