/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Collections;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ViewStackPanel;
import org.pepstock.jem.gwt.client.panels.administration.CertificatesPanel;
import org.pepstock.jem.gwt.client.panels.administration.CurrentQueuesPanel;
import org.pepstock.jem.gwt.client.panels.administration.GfsPanel;
import org.pepstock.jem.gwt.client.panels.administration.GrsPanel;
import org.pepstock.jem.gwt.client.panels.administration.InternalMapsPanel;
import org.pepstock.jem.gwt.client.panels.administration.MemoryPanel;
import org.pepstock.jem.gwt.client.panels.administration.NodesCommandsPanel;
import org.pepstock.jem.gwt.client.panels.administration.NodesConfigPanel;
import org.pepstock.jem.gwt.client.panels.administration.NodesQueuesPanel;
import org.pepstock.jem.gwt.client.panels.administration.NodesSystemPanel;
import org.pepstock.jem.gwt.client.panels.administration.QueuesPanel;
import org.pepstock.jem.gwt.client.panels.administration.RedoStatementPanel;
import org.pepstock.jem.gwt.client.panels.administration.SecretUtilityPanel;
import org.pepstock.jem.gwt.client.panels.administration.TreeOptions;
import org.pepstock.jem.gwt.client.panels.administration.WorkloadPanel;
import org.pepstock.jem.gwt.client.panels.administration.commons.Instances;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.stats.LightSample;
import org.pepstock.jem.node.stats.SampleComparator;

public class Administration
extends SplitLayoutPanel
implements InspectListener<String>,
ResizeCapable {
    private final Loading loading = new Loading();
    private ViewStackPanel viewStack = new ViewStackPanel();
    private TreeOptions options = new TreeOptions();
    private WorkloadPanel workload = new WorkloadPanel();
    private NodesSystemPanel nodesSystem = new NodesSystemPanel();
    private NodesQueuesPanel nodesQueues = new NodesQueuesPanel();
    private QueuesPanel queues = new QueuesPanel();
    private InternalMapsPanel internals = new InternalMapsPanel();
    private NodesConfigPanel nodesConfig = new NodesConfigPanel();
    private NodesCommandsPanel nodesCmd = new NodesCommandsPanel();
    private GrsPanel grs = new GrsPanel();
    private SecretUtilityPanel sec = new SecretUtilityPanel();
    private CurrentQueuesPanel currentQueues = new CurrentQueuesPanel();
    private RedoStatementPanel redos = new RedoStatementPanel();
    private GfsPanel gfs = new GfsPanel();
    private MemoryPanel memory = new MemoryPanel();
    private CertificatesPanel certificate = new CertificatesPanel();

    public Administration() {
        this.options.setListener(this);
        this.addWest((Widget)this.options, 200.0);
        this.viewStack.add((Widget)new VerticalPanel());
        this.viewStack.add((Widget)this.workload);
        this.viewStack.add((Widget)this.nodesSystem);
        this.viewStack.add((Widget)this.nodesQueues);
        this.viewStack.add((Widget)this.queues);
        this.viewStack.add((Widget)this.grs);
        this.viewStack.add((Widget)this.nodesConfig);
        this.viewStack.add((Widget)this.nodesCmd);
        this.viewStack.add((Widget)this.currentQueues);
        this.viewStack.add((Widget)this.sec);
        this.viewStack.add((Widget)this.redos);
        this.viewStack.add((Widget)this.gfs);
        this.viewStack.add((Widget)this.memory);
        this.viewStack.add((Widget)this.certificate);
        this.viewStack.add((Widget)this.internals);
        this.add((Widget)this.viewStack);
    }

    @Override
    public void inspect(String object) {
        if (object.equalsIgnoreCase("current-queues-status")) {
            this.loadCurrentSample(object);
        } else if (object.equalsIgnoreCase("internal_maps")) {
            this.loadCurrentSample(object);
        } else if (object.equalsIgnoreCase("grs-contentions")) {
            this.onResultLoaded(object);
        } else if (object.equalsIgnoreCase("nodes-configuration")) {
            this.onResultLoaded(object);
        } else if (object.equalsIgnoreCase("nodes-commands")) {
            this.onResultLoaded(object);
        } else if (object.equalsIgnoreCase("secret-utility")) {
            this.onResultLoaded(object);
        } else if (object.equalsIgnoreCase("certificate-panel")) {
            this.onResultLoaded(object);
        } else {
            this.loadAllSamples(object);
        }
    }

    public void onResultLoaded(String option) {
        if (option.equalsIgnoreCase("workload-jobs")) {
            this.viewStack.showStack(1);
            this.workload.load();
        } else if (option.equalsIgnoreCase("nodes-system-status")) {
            this.viewStack.showStack(2);
            this.nodesSystem.load();
        } else if (option.equalsIgnoreCase("nodes-queues-status")) {
            this.viewStack.showStack(3);
            this.nodesQueues.load();
        } else if (option.equalsIgnoreCase("queues-status")) {
            this.viewStack.showStack(4);
            this.queues.load();
        } else if (option.equalsIgnoreCase("grs-contentions")) {
            this.viewStack.showStack(5);
            this.grs.load();
        } else if (option.equalsIgnoreCase("nodes-configuration")) {
            this.viewStack.showStack(6);
            this.nodesConfig.load();
        } else if (option.equalsIgnoreCase("nodes-commands")) {
            this.viewStack.showStack(7);
            this.nodesCmd.load();
        } else if (option.equalsIgnoreCase("current-queues-status")) {
            this.viewStack.showStack(8);
            this.currentQueues.load();
        } else if (option.equalsIgnoreCase("secret-utility")) {
            this.viewStack.showStack(9);
        } else if (option.equalsIgnoreCase("redo-panel")) {
            this.viewStack.showStack(10);
            this.redos.load();
        } else if (option.equalsIgnoreCase("gfs-panel")) {
            this.viewStack.showStack(11);
            this.gfs.load();
        } else if (option.equalsIgnoreCase("memory-panel")) {
            this.viewStack.showStack(12);
            this.memory.load();
        } else if (option.equalsIgnoreCase("certificate-panel")) {
            this.viewStack.showStack(13);
        } else if (option.equalsIgnoreCase("internal_maps")) {
            this.viewStack.showStack(14);
            this.internals.load();
        }
    }

    private void loadAllSamples(final String what) {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.STATS_MANAGER.getSamples(new AsyncCallback<Collection<LightSample>>(){

                    public void onFailure(Throwable caught) {
                        Administration.this.loading.stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Get samples error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(Collection<LightSample> result) {
                        if (result != null) {
                            if (!result.isEmpty()) {
                                Instances.setSamples(result);
                                Instances.setLastSample(Collections.max(result, new SampleComparator()));
                                Administration.this.onResultLoaded(what);
                            } else {
                                AlertMessageBox alert = new AlertMessageBox(1, "Samples empty!", "The result of samples is empty!<br>Probably JEM nodes started but they haven't create any statistics sample.");
                                alert.open();
                            }
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Samples empty!", "The result of samples is empty!<br>Probably JEM nodes started but they haven't create any statistics sample.");
                            alert.open();
                        }
                        Administration.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    private void loadCurrentSample(final String what) {
        this.loading.startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.STATS_MANAGER.getCurrentSample(new AsyncCallback<LightSample>(){

                    public void onFailure(Throwable caught) {
                        Administration.this.loading.stopProcessing();
                        AlertMessageBox alert = new AlertMessageBox(2, "Get last sample error!", caught.getMessage());
                        alert.open();
                    }

                    public void onSuccess(LightSample result) {
                        if (result != null) {
                            Instances.setCurrentSample(result);
                            Administration.this.onResultLoaded(what);
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Sample empty!", "The result of samples is empty!<br>Probably JEM nodes started but they haven't create any statistics sample.");
                            alert.open();
                        }
                        Administration.this.loading.stopProcessing();
                    }
                });
            }
        });
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.setSize(Sizes.toString(availableWidth), Sizes.toString(availableHeight));
        int desiredWidth = availableWidth - 200 - 8;
        int desiredHeight = availableHeight;
        for (Widget w : this.viewStack.getWidgets()) {
            w.setSize(Sizes.toString(desiredWidth), Sizes.toString(desiredHeight));
            if (!(w instanceof ResizeCapable)) continue;
            ((ResizeCapable)w).onResize(desiredWidth, desiredHeight);
        }
    }
}

