/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.editor.Editor;
import org.pepstock.jem.gwt.client.editor.SyntaxHighlighter;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public abstract class AbstractSyntaxHighlighter
extends VerticalPanel
implements SyntaxHighlighter {
    private String content = null;
    private Editor editor = null;
    private boolean editorStarted = false;
    private MenuBar menu = new MenuBar();
    private MenuItem selectedFontItem = null;

    public AbstractSyntaxHighlighter() {
        this(null, null);
    }

    public AbstractSyntaxHighlighter(String id) {
        this(id, null);
    }

    public AbstractSyntaxHighlighter(String id, String content) {
        this.content = content;
        this.menu.addStyleName(Styles.INSTANCE.common().editMenuBar());
        this.menu.setHeight(Sizes.toString(33));
        this.menu.setAnimationEnabled(true);
        this.add((Widget)this.menu);
        this.editor = id == null ? new Editor() : new Editor(id);
        this.add(this.editor);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        if (this.editorStarted) {
            this.editor.setText(content);
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    @Override
    public void startEditor() {
        if (!this.editorStarted) {
            this.editor.start();
            this.setEditorAttributes(this.editor);
            this.editor.setText(this.content);
            this.editorStarted = true;
            String pref = CurrentUser.getInstance().getStringPreference("job.edit.fontsize");
            if (pref == null) {
                pref = "small";
            }
            MenuBar fontSizeMenu = new MenuBar(true);
            MenuItem small = this.createMenuItem("Small", "small", pref);
            MenuItem medium = this.createMenuItem("Medium", "medium", pref);
            MenuItem large = this.createMenuItem("Large", "large", pref);
            MenuItem extraLarge = this.createMenuItem("Extra-Large", "x-large", pref);
            fontSizeMenu.addItem(small);
            fontSizeMenu.addItem(medium);
            fontSizeMenu.addItem(large);
            fontSizeMenu.addItem(extraLarge);
            if (this.content.equalsIgnoreCase("JCL not available")) {
                small.setEnabled(false);
                medium.setEnabled(false);
                large.setEnabled(false);
                extraLarge.setEnabled(false);
            }
            Image imgFontSize = new Image(Images.INSTANCE.edit_font_size());
            imgFontSize.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
            MenuItem fontSizeMenuItem = new MenuItem(imgFontSize + "  Size", true, fontSizeMenu);
            this.menu.addItem(fontSizeMenuItem);
            this.setMenuItems(this.menu, this.content.equalsIgnoreCase("JCL not available"));
        }
    }

    public abstract void setEditorAttributes(Editor var1);

    public abstract void setMenuItems(MenuBar var1, boolean var2);

    private MenuItem createMenuItem(String label, final String fontStyle, String preference) {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        builder.appendHtmlConstant("<div style='font-size: " + fontStyle + ";'>" + label + "</div>");
        final MenuItem item = new MenuItem(builder.toSafeHtml());
        item.setScheduledCommand((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                AbstractSyntaxHighlighter.this.editor.setFontSize(fontStyle);
                CurrentUser.getInstance().setStringPreference("job.edit.fontsize", fontStyle);
                AbstractSyntaxHighlighter.this.selectedFontItem.setEnabled(true);
                AbstractSyntaxHighlighter.this.selectedFontItem.removeStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
                item.setEnabled(false);
                item.addStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
                AbstractSyntaxHighlighter.this.selectedFontItem = item;
            }
        });
        if (preference.equalsIgnoreCase(fontStyle)) {
            this.selectedFontItem = item;
            item.setEnabled(false);
            item.addStyleName(Styles.INSTANCE.common().editMenuItemDisabled());
            this.editor.setFontSize(fontStyle);
        }
        return item;
    }

    @Override
    public void destroyEditor() {
        if (this.editorStarted) {
            this.editor.destroy();
        }
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.menu.setWidth(Sizes.toString(availableWidth - 2));
        this.editor.setWidth(Sizes.toString(availableWidth));
        this.editor.setHeight(Sizes.toString(availableHeight - 33));
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

