/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.notify.MessagesCollection;
import org.pepstock.jem.gwt.client.notify.ToastMessage;

public class Toast
extends PopupPanel {
    private boolean timerStopped = false;

    public Toast(int level, String message, String title) {
        this(message, title);
        String theStyle;
        switch (level) {
            case 1: {
                theStyle = Styles.INSTANCE.toast().yellow();
                break;
            }
            case 2: {
                theStyle = Styles.INSTANCE.toast().red();
                break;
            }
            default: {
                theStyle = Styles.INSTANCE.toast().lightGreen();
            }
        }
        this.addStyleName(theStyle);
        ToastMessage tMessage = new ToastMessage();
        tMessage.setLevel(level);
        tMessage.setMessage(message);
        tMessage.setTitle(title);
        MessagesCollection.add(tMessage);
    }

    public Toast(String style, String message, String title) {
        this(message, title);
        this.addStyleName(style);
    }

    protected Toast(String message, String title) {
        this.setStyleName(Styles.INSTANCE.toast().main());
        VerticalPanel panel = new VerticalPanel();
        panel.setSpacing(2);
        if (title != null) {
            Label t = new Label(title);
            t.addStyleName(Styles.INSTANCE.toast().title());
            panel.add((Widget)t);
        }
        if (message != null) {
            HTML m = new HTML(message);
            m.addStyleName(Styles.INSTANCE.toast().message());
            panel.add((Widget)m);
        }
        int maxWidth = Window.getClientWidth() * 75 / 100;
        this.getElement().getStyle().setPropertyPx("maxWidth", maxWidth);
        this.setWidget((Widget)panel);
    }

    public final void show() {
        this.setVisible(false);
        super.show();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                int left = (Window.getClientWidth() - Toast.this.getOffsetWidth()) / 2;
                int top = 106 - Toast.this.getOffsetHeight();
                Toast.this.setPopupPosition(left, top);
                Toast.this.setVisible(true);
                Timer t = new Timer(){

                    public void run() {
                        if (!Toast.this.timerStopped) {
                            Toast.this.hide();
                        }
                    }
                };
                t.schedule(3000);
            }
        });
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        switch (event.getTypeInt()) {
            case 128: {
                if (event.getNativeEvent().getKeyCode() != 27) break;
                this.hide();
                break;
            }
            case 1: {
                boolean insidePopup;
                if (!this.isShowing() || (insidePopup = this.isClickInsideElement(event.getNativeEvent(), (Widget)this))) break;
                this.hide();
                break;
            }
            case 16: {
                boolean insidePopup;
                if (!this.isShowing() || !(insidePopup = this.isClickInsideElement(event.getNativeEvent(), (Widget)this))) break;
                this.timerStopped = true;
                break;
            }
            case 32: {
                boolean insidePopup;
                if (!this.isShowing() || !this.timerStopped || (insidePopup = this.isClickInsideElement(event.getNativeEvent(), (Widget)this))) break;
                this.hide();
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean isClickInsideElement(NativeEvent event, Widget w) {
        int x = event.getClientX();
        int y = event.getClientY();
        int top = w.getAbsoluteTop();
        int bottom = top + w.getOffsetHeight();
        int left = w.getAbsoluteLeft();
        int right = left + w.getOffsetWidth();
        if (x < left || x > right) {
            return false;
        }
        return y >= top && y <= bottom;
    }

    static {
        Styles.INSTANCE.toast().ensureInjected();
    }
}

