/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.SearcherHistoryView;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public class SearcherTextBox
extends FlexTable {
    private final TextBox textBox = new TextBox();
    private boolean focus = false;
    private String preferenceKey = null;
    private SearcherHistoryView view = null;
    private Button searchButton = null;

    public SearcherTextBox() {
        this.setPreferenceKey(this.preferenceKey);
        this.addStyleName(Styles.INSTANCE.common().searcher());
        this.textBox.addStyleName(Styles.INSTANCE.common().searcherTextBox());
        this.textBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (SearcherTextBox.this.focus) {
                    SearcherTextBox.this.removeStyleName(Styles.INSTANCE.common().searcherFocus());
                    SearcherTextBox.this.focus = false;
                }
            }
        });
        this.textBox.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (!SearcherTextBox.this.focus) {
                    SearcherTextBox.this.addStyleName(Styles.INSTANCE.common().searcherFocus());
                    SearcherTextBox.this.focus = true;
                }
            }
        });
        this.setCellPadding(2);
        this.setCellSpacing(0);
        this.setWidget(0, 0, (Widget)this.textBox);
        final Image searchImg = new Image(Images.INSTANCE.history());
        searchImg.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.MIDDLE);
        searchImg.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                searchImg.getElement().getStyle().setCursor(Style.Cursor.POINTER);
            }
        });
        searchImg.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                searchImg.getElement().getStyle().setCursor(Style.Cursor.AUTO);
            }
        });
        this.setWidget(0, 1, (Widget)searchImg);
        searchImg.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SearcherTextBox.this.view != null) {
                    SearcherTextBox.this.view.hide();
                } else if (SearcherTextBox.this.getPreferenceKey() != null) {
                    LinkedList<String> list = CurrentUser.getInstance().getListPreference(SearcherTextBox.this.getPreferenceKey());
                    if (list != null) {
                        if (!list.isEmpty()) {
                            int height;
                            int left = SearcherTextBox.this.getAbsoluteLeft();
                            int width = SearcherTextBox.this.getOffsetWidth() - 2;
                            int top = SearcherTextBox.this.getAbsoluteTop() + SearcherTextBox.this.getOffsetHeight();
                            int totHeight = top + (height = 24 * list.size());
                            if (totHeight > Window.getClientHeight()) {
                                height = Window.getClientHeight() - top * 2;
                            }
                            if (Window.Navigator.getUserAgent().contains("MSIE 10")) {
                                ++left;
                                ++top;
                            }
                            SearcherTextBox.this.view = new SearcherHistoryView(SearcherTextBox.this.getPreferenceKey());
                            SearcherTextBox.this.view.setSearcherTextBox(SearcherTextBox.this);
                            SearcherTextBox.this.view.setSearchImage(searchImg);
                            SearcherTextBox.this.view.setRowData(list);
                            SearcherTextBox.this.view.setPopupPosition(left, top);
                            SearcherTextBox.this.view.setSize(Sizes.toString(width), Sizes.toString(height));
                            SearcherTextBox.this.view.show();
                            SearcherTextBox.this.view.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> event) {
                                    SearcherTextBox.this.view = null;
                                }
                            });
                        } else {
                            Toast t = new Toast(0, "History is empty. Perfom a search!", "No history!");
                            t.show();
                        }
                    } else {
                        Toast t = new Toast(0, "History is empty. Perfom a search!", "No history!");
                        t.show();
                    }
                }
            }
        });
        FlexTable.FlexCellFormatter formatter = this.getFlexCellFormatter();
        formatter.setWidth(0, 0, "100%");
        formatter.setWidth(0, 1, Sizes.toString(searchImg.getWidth() + 1));
        formatter.setVerticalAlignment(0, 1, HasVerticalAlignment.ALIGN_MIDDLE);
    }

    public void hide() {
        if (this.view != null) {
            this.view.hide();
        }
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    public void setSearchButton(Button searchButton) {
        this.searchButton = searchButton;
    }

    public void setFilter(String filter) {
        this.textBox.setText(filter);
        if (this.searchButton != null && this.searchButton.isEnabled()) {
            this.searchButton.click();
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.textBox.setReadOnly(readOnly);
        if (readOnly) {
            this.addStyleName(Styles.INSTANCE.common().searcherUnabled());
        } else {
            this.removeStyleName(Styles.INSTANCE.common().searcherUnabled());
        }
    }

    public void addKeyPressHandler(KeyPressHandler handler) {
        this.textBox.addKeyPressHandler(handler);
    }

    public void addKeyUpHandler(KeyUpHandler handler) {
        this.textBox.addKeyUpHandler(handler);
    }

    public void addKeyDownHandler(KeyDownHandler handler) {
        this.textBox.addKeyDownHandler(handler);
    }

    public void setText(String text) {
        this.textBox.setText(text);
    }

    public String getText() {
        return this.textBox.getText();
    }

    public void setFocus(boolean focus) {
        this.textBox.setFocus(focus);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.textBox().ensureInjected();
    }
}

