/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.pepstock.jem.gwt.client.commons.CellTableStyle;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.SearcherTextBox;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.security.CurrentUser;

public class SearcherHistoryView
extends PopupPanel {
    public static final int CELL_HEIGHT = 20;
    public static final int CELL_PADDING = 2;
    private HistoryCell cell = new HistoryCell();
    private CellList<String> cellList = null;
    private ScrollPanel cellListScroller = new ScrollPanel();
    private SearcherTextBox searcherTextBox = null;
    private Image searchImage = null;
    private String preferenceKey = null;
    private boolean onClickToRemove = false;

    public SearcherHistoryView(String preferenceKey) {
        this.setPreferenceKey(preferenceKey);
        this.setStyleName(Styles.INSTANCE.common().searcherHistory());
        this.cellList = new CellList((Cell)this.cell, (CellList.Resources)GWT.create(CellTableStyle.class));
        this.cellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        this.cellList.setSelectionModel((SelectionModel)selectionModel);
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (!SearcherHistoryView.this.onClickToRemove) {
                    SearcherHistoryView.this.select((String)selectionModel.getSelectedObject());
                } else {
                    SearcherHistoryView.this.onClickToRemove = false;
                }
            }
        });
        this.cellListScroller.setWidget(this.cellList);
        VerticalPanel scrollHolder = new VerticalPanel();
        scrollHolder.setSize("100%", "100%");
        scrollHolder.add((Widget)this.cellListScroller);
        this.add((Widget)scrollHolder);
    }

    public void setSize(String width, String height) {
        super.setSize(width, height);
        this.cellListScroller.setSize(width, height);
    }

    public SearcherTextBox getSearcherTextBox() {
        return this.searcherTextBox;
    }

    public void setSearcherTextBox(SearcherTextBox searcherTextBox) {
        this.searcherTextBox = searcherTextBox;
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void setPreferenceKey(String preferenceKey) {
        this.preferenceKey = preferenceKey;
    }

    public Image getSearchImage() {
        return this.searchImage;
    }

    public void setSearchImage(Image searchImage) {
        this.searchImage = searchImage;
    }

    public void setRowData(Collection<String> history) {
        this.cellList.setRowCount(history.size(), true);
        this.cellList.setRowData(0, new ArrayList<String>(history));
        this.cellList.redraw();
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        switch (event.getTypeInt()) {
            case 128: {
                if (event.getNativeEvent().getKeyCode() != 27) break;
                this.hide();
                break;
            }
            case 1: {
                boolean insideImage;
                boolean insidePopup;
                if (!this.isShowing() || (insidePopup = this.isClickInsideElement(event.getNativeEvent(), (Widget)this)) || (insideImage = this.isClickInsideElement(event.getNativeEvent(), (Widget)this.getSearchImage()))) break;
                this.hide();
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean isClickInsideElement(NativeEvent event, Widget w) {
        int x = event.getClientX();
        int y = event.getClientY();
        int top = w.getAbsoluteTop();
        int bottom = top + w.getOffsetHeight();
        int left = w.getAbsoluteLeft();
        int right = left + w.getOffsetWidth();
        if (x < left || x > right) {
            return false;
        }
        return y >= top && y <= bottom;
    }

    private void select(String value) {
        this.hide();
        if (value != null && this.getSearcherTextBox() != null) {
            this.getSearcherTextBox().setFilter(value);
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }

    class HistoryCell
    extends AbstractCell<String> {
        HistoryCell() {
            super(new String[0]);
        }

        public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
            if (value != null) {
                AbstractImagePrototype proto = AbstractImagePrototype.create((ImageResource)Images.INSTANCE.delete());
                sb.appendHtmlConstant("<table cellpadding=2 cellspacing=0 width='100%'><tr><td style='padding-left: 4px;' width='100%' height=20>");
                sb.appendEscaped(value);
                sb.appendHtmlConstant("</td><td width='16px'>");
                sb.appendHtmlConstant(proto.getHTML());
                sb.appendHtmlConstant("</td></tr></table>");
            }
        }

        public Set<String> getConsumedEvents() {
            HashSet<String> consumedEvents = super.getConsumedEvents();
            if (consumedEvents == null) {
                consumedEvents = new HashSet<String>();
            }
            consumedEvents.add("mouseover");
            consumedEvents.add("mouseout");
            consumedEvents.add("click");
            return consumedEvents;
        }

        public void onBrowserEvent(Cell.Context context, Element parent, String value, NativeEvent event, ValueUpdater<String> valueUpdater) {
            super.onBrowserEvent(context, parent, (Object)value, event, valueUpdater);
            try {
                if ("mouseover".equals(event.getType())) {
                    parent.getStyle().setBackgroundColor("#ffe699");
                } else if ("mouseout".equals(event.getType())) {
                    parent.getStyle().setBackgroundColor("white");
                } else if ("click".equals(event.getType())) {
                    SearcherHistoryView.this.onClickToRemove = true;
                    int x = event.getClientX();
                    int y = event.getClientY();
                    int top = parent.getAbsoluteTop();
                    int bottom = parent.getAbsoluteBottom();
                    int left = parent.getAbsoluteRight() - 16;
                    int right = parent.getAbsoluteRight();
                    if (x < left || x > right) {
                        SearcherHistoryView.this.select(value);
                        return;
                    }
                    if (y < top || y > bottom) {
                        SearcherHistoryView.this.select(value);
                        return;
                    }
                    LinkedList<String> list = CurrentUser.getInstance().getListPreference(SearcherHistoryView.this.getPreferenceKey());
                    list.remove(value);
                    CurrentUser.getInstance().setLastUpdateTime();
                    if (list.isEmpty()) {
                        SearcherHistoryView.this.hide();
                    } else {
                        SearcherHistoryView.this.setRowData(list);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

