/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.commons;

import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;

public abstract class AbstractInspector
extends PopupPanel {
    private int width = Window.getClientWidth() * 3 / 4;
    private int height = Window.getClientHeight() * 3 / 4;
    private int availableHeight = this.height - 75;
    private int availableWidth = this.width;
    private VerticalPanel mainContainer = new VerticalPanel();
    private boolean hasActions = false;

    public AbstractInspector() {
        this(false);
    }

    public AbstractInspector(boolean hasActions) {
        super(true, true);
        this.setGlassEnabled(true);
        this.hasActions = hasActions;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final int getHeight() {
        return this.height;
    }

    public int getAvailableHeight() {
        return this.availableHeight;
    }

    public int getAvailableWidth() {
        return this.availableWidth;
    }

    public abstract FlexTable getHeader();

    public abstract Panel getContent();

    public abstract Panel getActions();

    public void show() {
        this.setSize(Sizes.toString(this.width), Sizes.toString(this.height));
        if (this.hasActions) {
            this.availableHeight -= 60;
        }
        FlexTable h = this.getHeader();
        h.setHeight(Sizes.toString(75));
        this.mainContainer.add((Widget)h);
        Panel c = this.getContent();
        if (c instanceof ResizeCapable) {
            ResizeCapable rc = (ResizeCapable)c;
            rc.onResize(this.getAvailableWidth(), this.getAvailableHeight());
        } else {
            c.setHeight(Sizes.toString(this.getAvailableHeight()));
        }
        this.mainContainer.add((Widget)c);
        if (this.hasActions) {
            Panel a = this.getActions();
            a.setHeight(Sizes.toString(60));
            this.mainContainer.add((Widget)a);
        }
        this.setWidget((Widget)this.mainContainer);
        super.show();
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        switch (event.getTypeInt()) {
            case 128: {
                if (event.getNativeEvent().getKeyCode() != 27) break;
                this.hide();
                break;
            }
            default: {
                return;
            }
        }
    }
}

