/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.about;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.about.AboutHeader;
import org.pepstock.jem.gwt.client.about.Actions;
import org.pepstock.jem.gwt.client.commons.AbstractInspector;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.UITools;
import org.pepstock.jem.node.About;
import org.pepstock.jem.node.NodeLicense;

public class AboutPanel
extends AbstractInspector {
    private ScrollPanel main = new ScrollPanel();

    public AboutPanel(About about) {
        super(false);
        Anchor site = new Anchor("www.pepstock.org");
        site.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.open((String)"http://www.pepstock.org/", (String)"_blank", (String)"");
            }
        });
        VerticalPanel tableContainer = new VerticalPanel();
        tableContainer.setSize("100%", "100%");
        tableContainer.setSpacing(10);
        Label aboutLabel = new Label("About JEM");
        aboutLabel.setWidth("100%");
        aboutLabel.setStyleName(Styles.INSTANCE.inspector().title());
        aboutLabel.addStyleName(Styles.INSTANCE.common().bold());
        FlexTable aboutTable = new FlexTable();
        aboutTable.setCellPadding(10);
        aboutTable.setSize("100%", "100%");
        aboutTable.addStyleName(Styles.INSTANCE.common().noWrap());
        aboutTable.getColumnFormatter().setWidth(1, "80%");
        aboutTable.setHTML(0, 0, "Site");
        aboutTable.setWidget(0, 1, (Widget)site);
        aboutTable.setHTML(1, 0, "Version");
        aboutTable.setHTML(1, 1, about.getVersion());
        aboutTable.setHTML(2, 0, "Build time");
        aboutTable.setHTML(2, 1, about.getCreationTime());
        Label licensesLabel = new Label("Installed Licences");
        licensesLabel.setWidth("100%");
        licensesLabel.setStyleName(Styles.INSTANCE.inspector().title());
        licensesLabel.addStyleName(Styles.INSTANCE.common().bold());
        FlexTable licensesTable = new FlexTable();
        licensesTable.setCellPadding(10);
        licensesTable.setSize("100%", "100%");
        if (!about.getLicenses().isEmpty()) {
            int row = 0;
            for (NodeLicense license : about.getLicenses()) {
                StringBuffer builder = new StringBuffer();
                builder.append("Module: <b>" + license.getModule() + "</b>, ");
                builder.append("File name: <b>" + license.getFileName() + "</b><br/>");
                builder.append("Subject: <b>" + license.getSubject() + "</b>, ");
                builder.append("Email: <b>" + license.getEmail() + "</b>, ");
                builder.append("Issue date: <b>" + license.getIssuedate() + "</b>, ");
                builder.append("Expire date: <b>" + license.getExpiredate() + "</b>, ");
                builder.append("Max nodes: <b>" + license.getMaxnodes() + "</b>");
                licensesTable.setHTML(row, 0, builder.toString());
                ++row;
            }
        } else {
            licensesTable.setHTML(0, 0, "(none)");
        }
        UITools.setFlexTableRowStyles(aboutTable, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight());
        UITools.setFlexTableRowStyles(licensesTable, Styles.INSTANCE.inspector().rowDark(), Styles.INSTANCE.inspector().rowLight());
        tableContainer.add((Widget)aboutLabel);
        tableContainer.add((Widget)aboutTable);
        tableContainer.add((Widget)licensesLabel);
        tableContainer.add((Widget)licensesTable);
        this.main.add((Widget)tableContainer);
    }

    @Override
    public FlexTable getHeader() {
        return new AboutHeader(this);
    }

    @Override
    public Panel getContent() {
        this.main.setSize(Sizes.toString(this.getAvailableWidth()), Sizes.toString(this.getAvailableHeight()));
        return this.main;
    }

    @Override
    public Panel getActions() {
        return new Actions(this);
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.inspector().ensureInjected();
    }
}

