/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.LoggedListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.client.services.Services;

public class LoginBox
extends VerticalPanel {
    private final Loading loading = new Loading();
    private LoggedListener listener = null;
    private final TextBox useridInputBox = new TextBox();
    private final PasswordTextBox passwordInputBox = new PasswordTextBox();
    private final HorizontalPanel buttonAndEnvironment = new HorizontalPanel();
    private final Button loginButton = new Button("Login");
    private final InlineHTML environmentLabel = new InlineHTML();
    private final Label exceptionMessage = new Label();

    public LoginBox() {
        this.loading.setDelay(-1);
        this.setSpacing(10);
        this.addStyleName(Styles.INSTANCE.loginBox().grid());
        this.useridInputBox.setWidth("95%");
        this.passwordInputBox.setWidth("95%");
        this.buttonAndEnvironment.getElement().setId("buttonAndEnvironment");
        this.buttonAndEnvironment.setHorizontalAlignment(ALIGN_LEFT);
        this.buttonAndEnvironment.setVerticalAlignment(ALIGN_MIDDLE);
        this.loginButton.addStyleName(Styles.INSTANCE.common().defaultActionButton());
        this.buttonAndEnvironment.add((Widget)this.loginButton);
        this.buttonAndEnvironment.add((Widget)this.environmentLabel);
        this.environmentLabel.setVisible(false);
        this.buttonAndEnvironment.setCellWidth((Widget)this.environmentLabel, "100%");
        Services.INFO_SERVICE.getEnvironmentInformation(new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(String[] result) {
                String envName = result[0];
                LoginBox.this.environmentLabel.setHTML("&nbsp;&nbsp;on environment <b>" + envName + "</b>");
                LoginBox.this.environmentLabel.setVisible(true);
            }
        });
        this.exceptionMessage.setText(" ");
        this.useridInputBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13) {
                    LoginBox.this.loginButton.click();
                } else {
                    LoginBox.this.clearExceptionMessage();
                }
            }
        });
        this.passwordInputBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == 13) {
                    LoginBox.this.loginButton.click();
                } else {
                    LoginBox.this.clearExceptionMessage();
                }
            }
        });
        this.loginButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!LoginBox.this.checkUserIdAndPassword()) {
                    LoginBox.this.exceptionMessage.setText("Please insert User ID and Password");
                    LoginBox.this.exceptionMessage.addStyleName(Styles.INSTANCE.common().red());
                    return;
                }
                LoginBox.this.loading.startProcessing();
                Services.LOGIN_MANAGER.login(LoginBox.this.useridInputBox.getText(), LoginBox.this.passwordInputBox.getText(), new AsyncCallback<LoggedUser>(){

                    public void onFailure(Throwable caught) {
                        LoginBox.this.loading.stopProcessing();
                        LoginBox.this.exceptionMessage.setText(caught.getMessage());
                        LoginBox.this.exceptionMessage.addStyleName(Styles.INSTANCE.common().red());
                        LoginBox.this.passwordInputBox.setText("");
                        LoginBox.this.useridInputBox.setSelectionRange(0, LoginBox.this.useridInputBox.getText().length());
                    }

                    public void onSuccess(LoggedUser user) {
                        LoginBox.this.loading.stopProcessing();
                        if (user == null) {
                            AlertMessageBox alert = new AlertMessageBox(2, "User null!", "JEM returns a user null.<br> Please have a look into JEM log file to find the internal error.");
                            alert.open();
                        } else {
                            LoginBox.this.getListener().logged(user);
                        }
                    }
                });
            }
        });
        this.add((Widget)new HTML("Please insert your User ID and Password"));
        HTML userIdLabel = new HTML("User ID");
        userIdLabel.addStyleName(Styles.INSTANCE.common().bold());
        this.add((Widget)userIdLabel);
        this.add((Widget)this.useridInputBox);
        HTML passwordLabel = new HTML("Password");
        passwordLabel.addStyleName(Styles.INSTANCE.common().bold());
        this.add((Widget)passwordLabel);
        this.add((Widget)this.passwordInputBox);
        this.add((Widget)this.exceptionMessage);
        this.add((Widget)this.buttonAndEnvironment);
        this.setCellVerticalAlignment((Widget)this.buttonAndEnvironment, ALIGN_MIDDLE);
    }

    public final LoggedListener getListener() {
        return this.listener;
    }

    public void setListener(LoggedListener listener) {
        this.listener = listener;
    }

    private boolean checkUserIdAndPassword() {
        return !this.useridInputBox.getText().isEmpty() && !this.passwordInputBox.getText().isEmpty();
    }

    private void clearExceptionMessage() {
        if (!this.exceptionMessage.getText().trim().isEmpty()) {
            this.exceptionMessage.setText(" ");
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.loginBox().ensureInjected();
    }
}

