/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.SimpleJob;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;

public class StepRunner {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JobLauncher launcher;
    private JobRepository jobRepository;

    public StepRunner(JobLauncher launcher, JobRepository jobRepository) {
        this.launcher = launcher;
        this.jobRepository = jobRepository;
    }

    public JobExecution launchStep(Step step) {
        return this.launchStep(step, this.makeUniqueJobParameters());
    }

    public JobExecution launchStep(Step step, JobParameters jobParameters) {
        SimpleJob job = new SimpleJob();
        job.setName("TestJob");
        job.setJobRepository(this.jobRepository);
        ArrayList<Step> stepsToExecute = new ArrayList<Step>();
        stepsToExecute.add(step);
        job.setSteps(stepsToExecute);
        return this.launchJob((Job)job, jobParameters);
    }

    private JobExecution launchJob(Job job, JobParameters jobParameters) {
        try {
            return this.launcher.run(job, jobParameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new RuntimeException(e);
        }
        catch (JobRestartException e) {
            throw new RuntimeException(e);
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new RuntimeException(e);
        }
    }

    private JobParameters makeUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("timestamp", new JobParameter(Long.valueOf(new Date().getTime())));
        return new JobParameters(parameters);
    }
}

