/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Assert;
import org.springframework.core.io.Resource;

public abstract class AssertFile {
    public static void assertFileEquals(File expected, File actual) throws Exception {
        BufferedReader expectedReader = new BufferedReader(new FileReader(expected));
        BufferedReader actualReader = new BufferedReader(new FileReader(actual));
        try {
            int lineNum = 1;
            String expectedLine = null;
            while ((expectedLine = expectedReader.readLine()) != null) {
                String actualLine = actualReader.readLine();
                Assert.assertEquals((String)("Line number " + lineNum + " does not match."), (String)expectedLine, (String)actualLine);
                ++lineNum;
            }
            String actualLine = actualReader.readLine();
            Assert.assertEquals((String)("More lines than expected.  There should not be a line number " + lineNum + "."), null, (String)actualLine);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            expectedReader.close();
            actualReader.close();
        }
    }

    public static void assertFileEquals(Resource expected, Resource actual) throws Exception {
        AssertFile.assertFileEquals(expected.getFile(), actual.getFile());
    }
}

