/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingMethodAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.MethodNode;

public class MethodCallInliner
extends LocalVariablesSorter {
    private final String oldClass;
    private final String newClass;
    private final MethodNode mn;
    private List blocks = new ArrayList();
    private boolean inlining;

    private MethodCallInliner(int access, String desc, MethodVisitor mv, MethodNode mn, String oldClass, String newClass) {
        super(access, desc, mv);
        this.oldClass = oldClass;
        this.newClass = newClass;
        this.mn = mn;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (!this.canBeInlined(owner, name, desc)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        Map<String, String> map = Collections.singletonMap(this.oldClass, this.newClass);
        SimpleRemapper remapper = new SimpleRemapper(map);
        Label end = new Label();
        this.inlining = true;
        this.mn.instructions.resetLabels();
        this.mn.accept((MethodVisitor)new InliningAdapter(this, opcode == 184 ? 8 : 0, desc, (Remapper)remapper, end));
        this.inlining = false;
        super.visitLabel(end);
    }

    private boolean canBeInlined(String owner, String name, String desc) {
        return "org/codehaus/groovy/runtime/DefaultGroovyMethods".equals(owner);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (!this.inlining) {
            this.blocks.add(new CatchBlock(start, end, handler, type));
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    private static class CatchBlock {
        private final Label start;
        private final Label end;
        private final Label handler;
        private final String type;

        private CatchBlock(Label end, Label start, Label handler, String type) {
            this.end = end;
            this.start = start;
            this.handler = handler;
            this.type = type;
        }
    }

    public static class InliningAdapter
    extends RemappingMethodAdapter {
        private final LocalVariablesSorter lvs;
        private final Label end;

        public InliningAdapter(LocalVariablesSorter mv, int acc, String desc, Remapper remapper, Label end) {
            super(acc, desc, (MethodVisitor)mv, remapper);
            this.lvs = mv;
            this.end = end;
            int off = (acc & 8) != 0 ? 0 : 1;
            Type[] args = Type.getArgumentTypes((String)desc);
            for (int i = args.length - 1; i >= 0; --i) {
                super.visitVarInsn(args[i].getOpcode(54), i + off);
            }
            if (off > 0) {
                super.visitVarInsn(58, 0);
            }
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                super.visitJumpInsn(167, this.end);
            } else {
                super.visitInsn(opcode);
            }
        }

        public void visitMaxs(int stack, int locals) {
        }

        protected int newLocalMapping(Type type) {
            return this.lvs.newLocal(type);
        }
    }
}

