/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.jppf.client.JPPFClient;
import org.jppf.client.JPPFClientConnectionImpl;
import org.jppf.management.JMXConnectionWrapper;
import org.jppf.management.JMXDriverConnectionWrapper;
import org.jppf.management.JMXNodeConnectionWrapper;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.utils.FileUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.SystemUtils;

public class GridMonitor {
    private JPPFClient jppfClient = null;
    private String driverHost;
    private int managementPort;
    private JPPFManagement driver;
    private Map<String, JPPFManagement> nodes = new TreeMap<String, JPPFManagement>();
    private Timer timer = null;
    private final Map<String, List<NodeData>> dataMap = new TreeMap<String, List<NodeData>>();
    private long snapshotInterval = 1000L;
    private long startTime = 0L;

    public GridMonitor(String driverHost, int managementPort) throws Exception {
        this.driverHost = driverHost;
        this.managementPort = managementPort;
        this.init();
    }

    public GridMonitor(String driverHost, int managementPort, long snapshotInterval) throws Exception {
        this.driverHost = driverHost;
        this.managementPort = managementPort;
        this.init();
    }

    public GridMonitor(JPPFClient jppfClient) throws Exception {
        this.jppfClient = jppfClient;
        this.init();
    }

    public GridMonitor(JPPFClient jppfClient, long snapshotInterval) throws Exception {
        this.jppfClient = jppfClient;
        this.snapshotInterval = snapshotInterval;
        this.init();
    }

    private void init() throws Exception {
        this.driver = new JPPFManagement();
        if (this.jppfClient != null) {
            JPPFClientConnectionImpl connection = (JPPFClientConnectionImpl)this.jppfClient.getClientConnection();
            this.driver.jmx = connection.getJmxConnection();
        } else {
            boolean ssl = JPPFConfiguration.getProperties().getBoolean("jppf.ssl.enabled", false);
            this.driver.jmx = new JMXDriverConnectionWrapper(this.driverHost, this.managementPort, ssl);
            this.driver.jmx.connect();
        }
        while (!this.driver.jmx.isConnected()) {
            Thread.sleep(1L);
        }
        this.driver.memoryMBean = ManagementFactory.newPlatformMXBeanProxy(this.driver.jmx.getMbeanConnection(), "java.lang:type=Memory", MemoryMXBean.class);
        this.driver.runtimeMBean = ManagementFactory.newPlatformMXBeanProxy(this.driver.jmx.getMbeanConnection(), "java.lang:type=Runtime", RuntimeMXBean.class);
        Collection infoCollection = ((JMXDriverConnectionWrapper)this.driver.jmx).nodesInformation();
        for (JPPFManagementInfo info : infoCollection) {
            JMXNodeConnectionWrapper node = new JMXNodeConnectionWrapper(info.getHost(), info.getPort(), info.isSecure());
            node.connect();
            while (!node.isConnected()) {
                Thread.sleep(1L);
            }
            JPPFManagement nodeMgt = new JPPFManagement();
            nodeMgt.jmx = node;
            nodeMgt.memoryMBean = ManagementFactory.newPlatformMXBeanProxy(node.getMbeanConnection(), "java.lang:type=Memory", MemoryMXBean.class);
            nodeMgt.runtimeMBean = ManagementFactory.newPlatformMXBeanProxy(node.getMbeanConnection(), "java.lang:type=Runtime", RuntimeMXBean.class);
            this.nodes.put(node.getId(), nodeMgt);
        }
    }

    public void startMonitoring() {
        this.startTime = System.currentTimeMillis();
        this.timer = new Timer("GridMonitoring");
        this.timer.schedule((TimerTask)new DataUpdateTask(), 0L, this.snapshotInterval);
    }

    public void stopMonitoring() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    public void close() throws Exception {
        this.stopMonitoring();
        this.driver.jmx.close();
        this.driver = null;
        for (JPPFManagement node : this.nodes.values()) {
            node.jmx.close();
        }
        this.nodes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeData(String folder) {
        try {
            File dir = new File(folder);
            FileUtils.mkdirs((File)dir);
            int nodeCount = 1;
            for (Map.Entry<String, List<NodeData>> entry : this.dataMap.entrySet()) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(new File(dir, "node-" + nodeCount + ".csv")));
                try {
                    writer.write("node:," + entry.getKey() + '\n');
                    writer.write(NodeData.getHeader() + '\n');
                    for (NodeData data : entry.getValue()) {
                        writer.write(data.toCSV() + '\n');
                    }
                    writer.flush();
                }
                finally {
                    writer.close();
                }
                ++nodeCount;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPPFManagement getDriver() {
        return this.driver;
    }

    public JPPFManagement[] getNodes() {
        return this.nodes.values().toArray(new JPPFManagement[this.nodes.size()]);
    }

    public void testPIDs() {
        JPPFManagement[] nodes;
        JPPFManagement driver = this.getDriver();
        System.out.println("driver: " + this.getInfo(driver));
        for (JPPFManagement node : nodes = this.getNodes()) {
            System.out.println("node: " + this.getInfo(node));
        }
    }

    public String getInfo(JPPFManagement mgt) {
        StringBuilder sb = new StringBuilder();
        sb.append(mgt.jmx.getId()).append(", PID = ").append(SystemUtils.getPID());
        return sb.toString();
    }

    public class DataUpdateTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                for (Map.Entry entry : GridMonitor.this.nodes.entrySet()) {
                    JPPFManagement node = (JPPFManagement)entry.getValue();
                    String id = (String)entry.getKey();
                    NodeData data = new NodeData();
                    data.timestamp = System.currentTimeMillis() - GridMonitor.this.startTime;
                    MemoryUsage memUsage = node.memoryMBean.getHeapMemoryUsage();
                    data.committed = memUsage.getCommitted();
                    data.used = memUsage.getUsed();
                    data.maxAvailable = memUsage.getMax() - data.used;
                    Map map = GridMonitor.this.dataMap;
                    synchronized (map) {
                        LinkedList<NodeData> list = (LinkedList<NodeData>)GridMonitor.this.dataMap.get(id);
                        if (list == null) {
                            list = new LinkedList<NodeData>();
                            GridMonitor.this.dataMap.put(id, list);
                        }
                        list.add(data);
                    }
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class NodeData {
        public long timestamp;
        public long committed;
        public long used;
        public long maxAvailable;

        public static String getHeader() {
            return "timestamp,committed,used,maxAvailable";
        }

        public String toCSV() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.timestamp).append(',');
            sb.append(this.committed).append(',');
            sb.append(this.used).append(',');
            sb.append(this.maxAvailable);
            return sb.toString();
        }
    }

    public static class JPPFManagement {
        public JMXConnectionWrapper jmx;
        public MemoryMXBean memoryMBean;
        public RuntimeMXBean runtimeMBean;
    }
}

