/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.client.concurrent;

import java.util.LinkedList;
import java.util.List;
import org.jppf.client.JPPFJob;
import org.jppf.client.JPPFResultCollector;
import org.jppf.client.concurrent.FutureResultCollectorEvent;
import org.jppf.client.concurrent.FutureResultCollectorListener;
import org.jppf.client.event.TaskResultEvent;
import org.jppf.server.protocol.JPPFTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FutureResultCollector
extends JPPFResultCollector {
    private static Logger log = LoggerFactory.getLogger(FutureResultCollector.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private List<FutureResultCollectorListener> listeners = new LinkedList<FutureResultCollectorListener>();
    private String jobUuid = null;

    FutureResultCollector(JPPFJob job) {
        super(job);
        this.jobUuid = job.getUuid();
    }

    synchronized JPPFTask getTask(int position) {
        return this.job.getResults().getResult(position);
    }

    synchronized JPPFTask waitForTask(int position) {
        return this.waitForTask(position, Long.MAX_VALUE);
    }

    synchronized JPPFTask waitForTask(int position, long millis) {
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        boolean taskReceived = this.isTaskReceived(position);
        while (elapsed < millis && !taskReceived) {
            try {
                this.wait(millis - elapsed);
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            elapsed = System.currentTimeMillis() - start;
            taskReceived = this.isTaskReceived(position);
            if (elapsed < millis || taskReceived) continue;
            return null;
        }
        return this.job.getResults().getResult(position);
    }

    boolean isTaskReceived(int position) {
        return this.job.getResults().hasResult(position);
    }

    @Override
    public synchronized void resultsReceived(TaskResultEvent event) {
        super.resultsReceived(event);
        this.fireResultsReceived(event.getTaskList());
    }

    @Override
    protected void onComplete() {
        super.onComplete();
        this.fireResultsComplete();
    }

    synchronized void addListener(FutureResultCollectorListener listener) {
        this.listeners.add(listener);
    }

    synchronized void removeListener(FutureResultCollectorListener listener) {
        this.listeners.remove(listener);
    }

    synchronized void fireResultsReceived(List<JPPFTask> results) {
        FutureResultCollectorEvent event = new FutureResultCollectorEvent(this, results);
        for (FutureResultCollectorListener listener : this.listeners) {
            listener.resultsReceived(event);
        }
    }

    synchronized void fireResultsComplete() {
        FutureResultCollectorEvent event = new FutureResultCollectorEvent(this, null);
        for (FutureResultCollectorListener listener : this.listeners) {
            listener.resultsComplete(event);
        }
    }

    String getJobUuid() {
        return this.jobUuid;
    }
}

